% Sinus generator
% S3S6_1.m * mw * 09/12/2007
%% Initialization
w = pi/8;   % normalized radian frequency
a0 = 1; a1 = -2*cos(w); a2 = 1;   % denominator coefficients
n = 0:30;   % normalized time
%% Simulation
y = size(n);
y(1) = 0; y(2) = sin(w);  % initial conditions
for k=3:length(n)
    y(k) = -a1*y(k-1)-a2*y(k-2);   % DEQ
end
%% Graphics
FIG1 = figure('Name','S3S6_1 : Sinus generator','NumberTitle','off');
stem(n,y,'filled'), grid
    axis([0 length(n) -1.2 1.2]); title(['Sinus signal : \Omega_0 = \pi / ',num2str(pi/w)])
    xlabel('n \rightarrow'), ylabel('y[n] \rightarrow')