% Sinus generator
% S3S6_2.m * mw * 09/12/2007
%% Initialization
w = pi/8;   % normalized radian frequency
a0 = 1; a1 = -2*cos(w); a2 = 1;   % denominator coefficients
b0 = 0; b1 = sin(w);    b2 = 0;   % numerator coefficients
b = [b0 b1 b2]; a = [a0 a1 a2];
%% Simulation
L = 30;              % number of simulation cycles - 1
x = [1 zeros(1,L)];  % impulse function
y = filter(b,a,x);   % filtering
%% Graphics
FIG1 = figure('Name','S3S6_2 : Sinus generator','NumberTitle','off');
stem(0:L,y,'filled'), grid
    axis([0 L -1.2 1.2]); title(['Sinus signal : \Omega_0 = \pi / ',num2str(pi/w)])
    xlabel('n \rightarrow'), ylabel('y[n] \rightarrow')