% Sinus generator
% S3S6_3.m * mw * 09/12/2007
%% Initialization
w = pi/8;   % normalized radian frequency
a0 = 1; a1 = -2*cos(w); a2 = 1;   % denominator coefficients
b0 = 0; b1 = sin(w);    b2 = 0;   % numerator coefficients
b = [b0 b1 b2]; a = [a0 a1 a2];
%% Simulation
L = 31;           % computed length of impulse response
y = impz(b,a,L);  % impulse response
%% Graphics
FIG1 = figure('Name','S3S6_3 : Sinus generator','NumberTitle','off');
stem(0:L-1,y,'filled'), grid
    axis([0 L -1.2 1.2]); title(['Sinus signal : \Omega_0 = \pi / ',num2str(pi/w)])
    xlabel('n \rightarrow'), ylabel('y[n] \rightarrow')