% 2nd order System
% S3S6_7.m * mw * 09/12/2007
%% 2nd order System
b = [0 1 0]; a = [1 -1 .25];   % numerator and denominator
%% Pol-zero plot
FIG1 = figure('Name','S3S6_7 : Pole-zero Plot','NumberTitle','off');
zplane(b,a),grid
    title('Pole-zero Plot')
%% Analytical impulse response
L = 20; n = 0:L;
p = 1/2;
ha = (1/p)*n.*p.^n;
FIG2 = figure('Name','s3s6_7 : Impulse Response (analytical)','NumberTitle','off');
stem(n,ha,'filled'), grid
    axis([0 L -.6 1.2]); title('Impulse Response')
    xlabel('n \rightarrow'), ylabel('h_a[n] \rightarrow')
%% Simulation
FIG3 = figure('Name','s3s6_7 : Impulse Response (simulated)','NumberTitle','off');
hs = impz(b,a,L+1);
    stem(0:L,hs,'filled'),grid
    axis([0 L -.2 1.2]); title('Impulse Response')
    xlabel('n \rightarrow'), ylabel('h_s[n] \rightarrow')