% 2nd order System
% S3S6_8.m * mw * 09/12/2007
%% 2nd order System
b = [0 1 0]; a = [1 -1 .5];   % numerator and denominator
%% Poles and zeros
p = roots(a);  % poles
disp('Poles'), disp(p)
z = roots(b);  % zeros
disp('Zeros'), disp(z)
FIG1 = figure('Name','s3s6_8 : Pole-zero Plot','NumberTitle','off');
zplane(b,a),grid
    title('Pole-zero Plot')
%% Impulse response
L = 20;
h = impz(b,a,L+1);
FIG2 = figure('Name','s3s6_8 : Impulse Response','NumberTitle','off');
stem(0:L,h,'filled'),grid
    axis([0 L -.4 1.2]); title('Impulse Response')
    xlabel('n \rightarrow'), ylabel('h[n] \rightarrow')
%% Unit step response
n = 0:L; 
s_a = 2*(1-(1/sqrt(2)).^n.*cos((2*pi/8)*n)); % analytical
s_s = filter(b,a,ones(1,L+1));               % simulated
FIG3 = figure('Name','s3s6_8 : Unit Step Response','NumberTitle','off');
stem(n,s_s,'filled'),grid
    axis([0 L -.5 3]); title('Unit Step Response')
    xlabel('n \rightarrow'), ylabel('s[n] \rightarrow')
hold on
    plot(n,s_a,'--','LineWidth',2')
hold off