% Partial-fraction expansion, and impulse and 
% step response for 3rd order system
% s3s6_9 * mw * 09/12/2007
b = [0,.0883,.0633,0]; a = [1,-2.02,1.46,-.368]; % numerator and denominator
%% Partial-fraction expansion for impulse response
[r,p,k] = residue(b,[a 0]);
fprintf('residues and poles (h)\n');
for k=1:length(r)
fprintf('r%g = %7.4f + %7.4fj   ',k,real(r(k)),imag(r(k)))
fprintf('   p%g = %7.4f + %7.4fj\n',k,real(p(k)),imag(p(k)))
end
%% Impulse response (singular poles only)
L = 30; n = 0:L;
ha = zeros(size(n));
for k=1:length(r)
    if p(k) == 0
        ha(1) = ha(1)+ r(k);
    else
        ha = ha + r(k)*p(k).^n;
    end
end
hs = impz(b,a,L+1);
fprintf('Maximum deviation max|ha-hs| = %g\n',max(abs(ha-hs')))
%% Partial-fraction expansion for step response
[r,p,k] = residue(b,[a 0]-[0 a]);
fprintf('residues and poles (s)\n')
for k=1:length(r)
    fprintf('r%g = %7.4f + %7.4fj   ',k,real(r(k)),imag(r(k)))
    fprintf('   p%g = %7.4f + %7.4fj\n',k,real(p(k)),imag(p(k)))
end
%% Step response (singular poles only)
sa = zeros(size(n));
for k=1:length(r)
    if p(k) == 0
        sa(1) = sa(1)+ r(k);
    else
        sa = sa + r(k)*p(k).^n;
    end
end
ss = filter(b,a,ones(1,L+1));
fprintf('Maximum deviation max|sa-ss| = %g\n',max(abs(sa-ss)))
%% Graphics
FIG1 = figure('Name','Impulse and step response','NumberTitle','off');
subplot(1,2,1), stem(n,ha,'filled'); grid
    axis([0 L -.1 .5]); title('Impulse Response')
    xlabel('n \rightarrow'), ylabel('h[n] \rightarrow')
subplot(1,2,2), stem(n,ss,'filled'); grid
    axis([0 L -.1 2.5]); title('Step Response')
    xlabel('n \rightarrow'), ylabel('s[n] \rightarrow')
