% Show magnitude of the transfer function of 
% an IIR system in the complex z plane
% s3s6_10.m * mw * 09/12/2007
%% Inizialize system
b = [0 .0833 .0633 0]; a = [1 -2.02 1.46 -.38]; % numerator and denominator
%% Polar coordinates (supporting grid in z plane)
rho = 0:.025:1.5;
phi = 0:.025:2; phi=pi*phi;
Nrho = length(rho); Nphi = length(phi); z = zeros(Nrho,Nphi);
for k=1:Nrho
   for l=1:Nphi
      z(k,l) = rho(k)*cos(phi(l)) + j*rho(k)*sin(phi(l));
  end 
end
%% Compute transfer function (sinle poles only)
M = length(b)-1; % order of numerator polynomial
N = length(a)-1; % order of denominator polynomial
ZP = zeros(size(z));
for k=1:M+1 % numerator polynomial
  ZP = ZP + b(k)*z.^(M+1-k);  
end
NP = zeros(size(z)); 
for k=1:N+1 % denominator polynomial
  NP = NP + a(k)*z.^(N+1-k);  
end
H = (ZP./NP).*z.^(N-M); % transfer function
%% Contour plot
NAME = 's3s6_10 : Contour Plot';
FIG1 = figure('Name',NAME,'NumberTitle','off','Units','normal',...
  'Position',[.5 .4 .45  .55]);
V = [.001 .002 .005 .01 .02 .05 .1 .2 .5 1 2 5 10];
[CS,CH] = contour(real(z),imag(z),abs(H),V);
axis square
hold on
Cphi = 0:.005:2; Cphi=pi*Cphi;
Cz   = cos(Cphi) + j*sin(Cphi);
for Cr = .5:.5:1.5
  plot(Cr*real(Cz),Cr*imag(Cz),'k:')
end
hold off
clabel(CS,CH,V);
grid
xlabel('real part \rightarrow'), ylabel('imaginary part \rightarrow')
title('contour lines of |H(z)|')
%% Magnitude plot
NAME = 's3s6_10 : z plane';
FIG2 = figure('Name',NAME,'NumberTitle','off','Units','normal',...
  'Position',[.5 .4 .45  .55]);
HdB = 20*log10(abs(H)); HdB = max(HdB,-60); HdB = min(HdB,20);
grid, mesh(real(z),imag(z),HdB) 
axis([-1.5 1.5 -1.5 1.5 -60 20])
xlabel('real part \rightarrow'), ylabel('imaginary part \leftarrow')
zlabel('|H(z)| in dB \rightarrow')