% Partial-fraction expansion and impulse and step response
% for rational transfer function of real-valued system 
% with single poles
% s3s7_2.m * mw * 09/14/2007
%% Initialize system
% b = [1]; a = [1,2,2,1]; % numerator and denominator (3rd order)
% b = [1 2 1]; a = [1 2 2];
b = [0 1 0]; a = [1,3,1];
t = 0:.1:15;            % time period
%% Impulse response
[r,p,k]=residue(b,a) % partial fraction expansion
h = zeros(size(t));
for k=1:length(r)
    h = h + r(k)*exp(p(k)*t);
end
%% Step response
[r,p,k]=residue(b,[a 0]) % multiply a with s and partial-fraction expansion
s = zeros(size(t));
for k=1:length(r)
    s = s + r(k)*exp(p(k)*t);
end
%% Graphics
figure('Name',['Impulse response : # of poles',num2str(length(r))],'NumberTitle','off');
plot(t,h,t,s,'LineWidth',2),grid
xlabel('t \rightarrow'), ylabel('h(t) , s(t) \rightarrow')
legend('impulse response','step response')