% Plot frequency response
% s3s8_1.m * mw * 02/13/2008
w = 0.01:.01:10; % normlized radian frequency
H = j*w./(j*w+1); % frequency response
% Graphics
FIG1 = figure('Name','S3S8_1 : 1st order system','NumberTitle','off');
subplot(3,1,1), plot(w,abs(H),'LineWidth',2), grid
axis([0 10 0 1]); title('Magniude of frequency response')
    xlabel('\omega_n \rightarrow'), ylabel('| H_n(j\omega_n) | \rightarrow')
subplot(3,1,3), plot(w,-20*log10(abs(H)),'LineWidth',2), grid
axis([0 10 0 60]); title('Attenuation in dB')
    xlabel('\omega_n \rightarrow'), ylabel('a_n(\omega_n) in dB \rightarrow')
subplot(3,1,2), plot(w,angle(H)/pi,'LineWidth',2), grid
axis([0 10 0 1]); title('Phase of frequency response')
    xlabel('\omega_n \rightarrow'), ylabel('\langle ( H_n(j\omega_n)/\pi ) \rightarrow')
%
FIG2 = figure('Name','S3S8_1 : 1st order system','NumberTitle','off');
subplot(3,1,1), semilogx(w,abs(H),'LineWidth',2), grid
axis([0 10 0 1]); title('Magniude of frequency response')
    xlabel('\omega_n \rightarrow'), ylabel('| H_n(j\omega_n) | \rightarrow')
subplot(3,1,3), loglog(w,abs(H),'LineWidth',2), grid
axis([0 10 0 1]); title('Magniude of frequency response in logarithmic scale')
    xlabel('\omega_n \rightarrow'), ylabel('| H_n(j\omega_n) | \rightarrow')
subplot(3,1,2), semilogx(w,angle(H)/pi,'LineWidth',2), grid
axis([0 10 0 1]); title('Phase of frequency response')
    xlabel('\omega_n \rightarrow'), ylabel('\langle ( H_n(j\omega_n)/\pi ) \rightarrow')