% Plot frequency response of serial RLC circuit
% s3s8_2.m * mw * 09/17/2007
w = 1e5:1e4:1e6;                   % normlized radian frequency
R = 10; L = 470e-6; C = 10e-9;     %
alpha = R/(2*L);
w0    = 1/sqrt(L*C);
wr    = sqrt(w0^2-alpha^2);
s1 = -alpha + j*wr; s2 = conj(s1);     % under-dumped
H = (1/(L*C))./((j*w-s1).*(j*w-s2));   % frequency response
%% Graphics
FIG1 = figure('Name','S3S8_2 : Serial RLC circuit','NumberTitle','off');
semilogx(w,(abs(H)),'LineWidth',2), grid
axis([1e5 1e6 0 50]); title('Magnitude of frequency response')
    xlabel('\omega in Hz\rightarrow'), ylabel('| H(j\omega) |  \rightarrow')
%%
hold on
R = 5;
alpha = R/(2*L); wr = sqrt(w0^2-alpha^2);
s1 = -alpha + j*wr; s2 = conj(s1);     % under-dumped
H = (1/(L*C))./((j*w-s1).*(j*w-s2));   % frequency response
semilogx(w,(abs(H)),'LineWidth',2)
R = 20;
alpha = R/(2*L); wr = sqrt(w0^2-alpha^2);
s1 = -alpha + j*wr; s2 = conj(s1);     % under-dumped
H = (1/(L*C))./((j*w-s1).*(j*w-s2));   % frequency response
semilogx(w,(abs(H)),'LineWidth',2)
hold off