% Plot frequency response of 2nd order system
% s3s8_3.m * mw * 09/16/2007
w = 1e5:1e4:1e6; % normlized radian frequency
R1 = 1e6; R2 = 100; L = 470e-6; C = 10e-9 %
a = R1*L*C; b = (L+R1*R2*C)/a;
N = w.^2 -R2/a - j*w*b;       % numerator
D = w.^2 -(R1+R2)/a - j*w*b;  % denominator
H = N./D; % frequency response     
% Graphics
FIG1 = figure('Name','S3S8_3 : 2nd order system','NumberTitle','off');
semilogx(w,abs(H),'LineWidth',2), grid
axis([1e5 1e6 0 3]); title('Magnitude of frequency response')
    xlabel('\omega in Hz \rightarrow'), ylabel('| H(j\omega) | \rightarrow')