% Plot frequency response of 2nd order system
% s3s8_4.m * mw * 09/18/2007
w = 1e2:1e2:1e6; % normlized radian frequency
R1 = 100; R2 = 100; C1 = 1e-6; C2 = 1e-6; %
N = j*w /(R1*C2);       % numerator
D = w.^2 -1/(R1*R2*C1*C2) - j*w*(1/(R1*C1)+1/(R2*C2)+1/(R1*C2));  % denominator
H = N./D; % frequency response     
% Graphics
FIG1 = figure('Name','S3S8_3 : 2nd order system','NumberTitle','off');
semilogx(w,abs(H),'LineWidth',2), grid
axis([1e2 1e6 0 .4]); title('Magnitude of frequency response')
    xlabel('\omega in Hz \rightarrow'), ylabel('| H(j\omega) | \rightarrow')