% Plot frequency response of 2nd order system - universal filter
% s3s8_5.m * mw * 03/14/2008
w = 1e3:1e3:1e6; % normlized radian frequency
T1 = 1e-4; T2 = 1e-6;
%% Lowpass
C = 1/(T1*T2);
H1 = C*(1./(C-w.^2+j*w/T1)); % frequency response 
% Graphics
FIG1 = figure('Name','S3S8_5 : Lowpass','NumberTitle','off');
subplot(2,1,1), semilogx(w,abs(H1),'LineWidth',2), grid
    axis([1e3 1e6 0 10]); title('Magnitude of frequency response')
    xlabel('\omega in Hz \rightarrow'), ylabel('| H(j\omega) | \rightarrow')
subplot(2,1,2), loglog(w,abs(H1)/max(abs(H1)),'LineWidth',2), grid
    axis([1e3 1e6 1e-3 1]);
    xlabel('\omega in Hz \rightarrow'), ylabel('| H(j\omega) | / max \rightarrow')
%% Bandpass
C = 1/(T1*T2);
H2 = C*(j*w*T2)./(C-w.^2+j*w/T1); % frequency response 
% Graphics
FIG2 = figure('Name','S3S8_5 : Bandpass','NumberTitle','off');
subplot(2,1,1), semilogx(w,abs(H2),'LineWidth',2), grid
    axis([1e3 1e6 0 1]); title('Magnitude of frequency response')
    xlabel('\omega in Hz \rightarrow'), ylabel('| H(j\omega) | \rightarrow')
subplot(2,1,2), loglog(w,abs(H2)/max(abs(H2)),'LineWidth',2), grid
    axis([1e3 1e6 1e-3 1]);
    xlabel('\omega in Hz \rightarrow'), ylabel('| H(j\omega) | / max \rightarrow')
%% Highpass
C = 1/(T1*T2);
H3 = (-w.^2)./(C-w.^2+j*w/T1); % frequency response 
% Graphics
FIG3 = figure('Name','S3S8_5 : Highpass','NumberTitle','off');
subplot(2,1,1), semilogx(w,abs(H3),'LineWidth',2), grid
    axis([1e3 1e6 0 10]); title('Magnitude of frequency response')
    xlabel('\omega in Hz \rightarrow'), ylabel('| H(j\omega) | \rightarrow')
subplot(2,1,2), loglog(w,abs(H3)/max(abs(H3)),'LineWidth',2), grid
    axis([1e3 1e6 1e-3 1]);
    xlabel('\omega in Hz \rightarrow'), ylabel('| H(j\omega) | / max \rightarrow')