program analysis_deviance, rclass
version 10.0
syntax varname [if] [in], reduced(varlist) full(varlist)
qui {
	tempname prevest
	capture estimates preserve  `prevest'

	marksample touse
	
	binreg `varlist' `reduced' if `touse'
	local red_resid_deviance = e(deviance)
	local red_resid_df = e(df)

	binreg `varlist' `full' if `touse'
	local full_resid_deviance = e(deviance)
	local full_resid_df = e(df)

noi di ""
noi display as text "Analysis of Deviance Table"
noi di as text "{hline 8}{c TT}{hline 71}"
noi di as text "Reduced " "{c |}  " "`varname' `reduced'"
noi di as text "Full    " "{c |}  " "`varname' `full'"
noi di as text "{hline 8}{c BT}{hline 71}"
noi di ""
noi di as text "Model   " "{c |}" ///
" Resid. Df  Resid. Dev.   Df  Deviance  P(> chi2)"
noi di as text "{hline 8}{c +}{hline 50}"
local diffdf = `red_resid_df' - `full_resid_df'
local diffdev = `red_resid_deviance' - `full_resid_deviance'
local pdiffdev = 1 - chi2(`diffdf',`diffdev')
noi di as text "Reduced " "{c |}" " " %9.0g `red_resid_df' " " ///
%11.0g round(`red_resid_deviance',.001) 
noi di as text "Full    " "{c |}" " " %9.0g `full_resid_df' " " ///
%11.0g round(`full_resid_deviance',.001) " " %5.0g `diffdf' " " ///
%9.0g round(`diffdev',.001) " " %9.0g `pdiffdev'
}
noi di as text "{hline 8}{c BT}{hline 50}"
return scalar diffdf = `diffdf'
return scalar diffdev = `diffdev'
return scalar pdiffdev = `pdiffdev'
end


