/*smoother takes generate() option

no extra grid points produced by smoother

LINear means that should have an MMP of the XB
PREDictors means should have an MMP for each predictor

LINear and varlist         ok
LINear and PREDictors      ok
PREDictors and varlist     nok

MEAN ->  specifies option that is supplied to predict to get mean function
that is estimated in regression
*/
program mmp 
version 10.0
	syntax, Mean(string) SMOother(string) [LINear] ///
[VARlist(varlist numeric)] [Predictors] [SMOOPTions(string)] ///
[INDGoptions(string)] [GOPTions(string)]
qui {

	if ("`goptions'" != "") {
		local goptions `", `goptions'"'
	}	


	//so intermediate smoothing does not throw graphics up
	set graphics off
		//preserve estimates and data
	tempname presres
	capture estimates preserve `presres'
	preserve
	keep if e(sample)
	capture assert "`varlist'" != "" | "`predictors'" != "" | ///
"`linear'" != ""

		//ensure mmp is being used after estimation command
	capture assert 	"`e(cmd)'" != ""
	if (_rc != 0) {
	        di as error "Must be used after Estimation command."
	        exit 198
	}
		//predictors trumps varlist
	if ("`predictors'" != "") {
		tempname preds
		matrix `preds' = e(b)
		matrix list `preds'
		capture di _b[_cons]	
		local varlist: colnames `preds'
		local varlist: subinstr local varlist "_cons" ""
	}

	        //will keep track of how many graphs mmp will produce.
	local graphnumber = 1

                 //temporary variable holding the predictions
     	tempvar yhat
	capture predict `yhat', `mean'	
	
	if (_rc != 0) {
		di as error "Mean prediction option is incorrectly specified."
		exit 198
	}
	
	if ("`linear'" != "") {
			//preserve state and create holders for plotting
		tempfile a
                qui     save `a', replace
			//generate XB linear form
		tempvar linpred
		gen `linpred' = 0
		tempname preds
		matrix `preds' = e(b)
		local lflist: colnames `preds'
		tokenize `lflist'
		local n = colsof(`preds')
		capture di _b[_cons]
		if (_rc == 0) {
			local n = `n' - 1
		}

		forvalues i = 1/`n' {
			replace `linpred' = `linpred' + _b[``i'']*``i''
		}

		capture di _b[_cons]
		if (_rc == 0) {
			replace `linpred' = `linpred' + _b[_cons]
		}
		tempvar modellinform alternativelinform
		tempname gfit

		`smoother' `e(depvar)' `linpred', ///
generate(`alternativelinform')  `smooptions'
		`smoother' `yhat' `linpred', generate(`modellinform') /// 
`smooptions'
		scatter `e(depvar)' `linpred' || line `modellinform' ///
`linpred', sort lpattern("dash") lcolor("red") ///
|| line `alternativelinform' `linpred' , sort lcolor("blue") legend(off) ///
ytitle("`e(depvar)'") xtitle("Linear Form") name("`gfit'") `indgoptions'
		use `a', clear
	}
	foreach var of local varlist {
			//preserve state
		tempfile a
		qui save `a', replace	

		qui  bysort `var': keep if _n == 1
		if (_N > 2) {
				// predictor takes enough values to 
				// justify an mmp
				// restore state
			use `a', clear
			tempvar modellinform alternativelinform
			tempname g`graphnumber'
			`smoother' `e(depvar)' `var', ///
generate(`alternativelinform') `smooptions'
			`smoother' `yhat' `var', generate(`modellinform') ///
`smooptions'
			 scatter `e(depvar)' `var' || line `modellinform' /// 
`var', sort lpattern("dash") lcolor("red") || line `alternativelinform' ///
`var' , sort lcolor("blue") legend(off) ///
ytitle("`e(depvar)'") xtitle("`var'") name("`g`graphnumber''") `indgoptions' 
			local graphnumber = `graphnumber' + 1
			use `a', clear
            	}
		else {
			use `a', clear
		}
	}

		//draw mmps
	local graph `"graph combine"'
	local graphnumber = `graphnumber'-1
	forvalues i = 1/`graphnumber' {
		local graph `"`graph' `g`i''"'
	}
	set graphics on
	`graph' `gfit' `goptions'
	forvalues i = 1/`graphnumber' {
		graph drop `g`i''
	}
	if ("`gfit'" != "") {
		graph drop `gfit'
	}
	restore
	capture estimates restore `presres'
}
end
