program plot_lm
version 10.0
syntax, SMOother(name) *

	if ("`e(cmd)'" != "regress") {
		di as error "This must be run after linear regression"
		exit 198
	}
qui {
	tempname g1 g2 g3 g4 prevest 
	tempvar rtfit rtresid rtsrresid rtlvg rtcook zero absqtsr
	tempvar smortresid smoabsqtsr smortsr
	tempvar smortfit smortfitsr smortlvg
	tempvar out

	preserve
	estimates store `prevest'
 
	predict `rtfit', xb
	predict `rtresid', resid
	predict `rtsrresid', rstandard
	predict `rtlvg', leverage
	predict `rtcook', cook
	gen `absqtsr' = sqrt(abs(`rtsrresid'))

	gen `zero' = 0
	gen `smortresid' = .
	gen `smoabsqtsr' = .
	gen `smortsr' = .
	gen `smortfit' = .
	gen `smortfitsr'  = .
	gen `smortlvg' = .

	gen `out' = "" 

	tempname lvgcutoff
        local `lvgcutoff' = 2*(e(df_m)+1)/e(N)

	`smoother' `rtresid' `rtfit', store(`smortresid' `smortfit') `options'

	twoway scatter `rtresid' `rtfit' if `rtcook' < .5, mcolor(navy) ///
mlabel(`out') ///
|| scatter `rtresid' `rtfit' if `rtcook' >= .5 & `rtcook' < 1, ///
mcolor(yellow) mlabel(`out') ///
|| scatter `rtresid' `rtfit' if `rtcook' >= 1, mcolor(red) mlabel(`out') ///
|| line `zero' `rtfit', lpattern(dot) lcolor(gray) sort ///
|| line `smortresid' `smortfit', lpattern(dash) ///
lcolor(red) sort xtitle("Fitted Values") ytitle("Residuals") ///
title("Residuals vs. Fitted") name("`g1'") legend(off)  nodraw
	
	qnorm `rtsrresid', xtitle("Theoretical Quantiles") mcolor(black) ///
ytitle("Standardized Residuals") title("Normal Q-Q") name("`g2'") ///
legend(off) nodraw

	`smoother' `absqtsr' `rtfit', store(`smoabsqtsr' `smortfitsr') `options'
        twoway scatter `absqtsr' `rtfit' if `rtcook'<.5,mcolor(navy) ///
mlabel(`out') ///
|| scatter `absqtsr' `rtfit' if `rtcook' >= .5 & `rtcook' < 1, ///
mcolor(yellow) mlabel(`out') /// 
|| scatter `absqtsr' `rtfit' if `rtcook' >= 1, mcolor(red) mlabel(`out') ///
|| line `smoabsqtsr' `smortfitsr', lpattern(dash) lcolor(red) sort ///
xtitle("Fitted Values") ytitle("Square Root(|Standardized Residuals|)") ///
title("Scale-Location") name("`g3'") legend(off) nodraw
	
	`smoother' `rtsrresid' `rtlvg', store(`smortsr' `smortlvg') `options'
        twoway scatter `rtsrresid' `rtlvg' if `rtcook' < .5, mcolor(navy) ///
mlabel(`out') ///
|| scatter `rtsrresid' `rtlvg' if `rtcook' >= .5 & `rtcook' < 1, ///
mcolor(yellow) mlabel(`out') ///
|| scatter `rtsrresid' `rtlvg' if `rtcook' >= 1, mcolor(red) mlabel(`out') ///
|| line `zero' `rtlvg', lpattern(dot) lcolor(gray) sort ///
|| line `smortsr' `smortlvg', lpattern(dash) lcolor(red) sort ///
title("Residuals vs. Leverage") xline(``lvgcutoff'',lpattern(dash) ///
lcolor(black)) ytitle("Standardized Residuals") xtitle("Leverage") ///
ytitle("Standardized Residuals") name("`g4'") ///
legend(label(1 `"Cook [0,.5)"') label(2 `"Cook [.5,1)"')  ///
label(3 `"Cook [1,)"')) legend(order(1 2 3)) legend(rows(1)) ///
nodraw 

restore
estimates restore `prevest'
}
	graph combine `g1' `g2' `g3' `g4', xsize(10) ysize(10) altshrink
end
