program rlcipi, rclass
version 10.0
syntax , [PREDict] ARGuments(numlist min=1) Level(cilevel) LENgth(numlist integer min=1 max=1 >=0)  PRECision(numlist integer min=1 max=1 >=0)
preserve
tempname prevres
qui estimates store `prevres'
if(`length' < `precision') {
di as error "Precision must not exceed Length"
exit 198
}
capture assert "`e(cmd)'" == "regress"
if (_rc > 0) {
di as error "Command must be run after regress"
exit 198
}

if (`e(df_m)' != 1) {
di as error "Regression must have only one predictor."
exit 198
}
local a: word count `arguments'
local b = max(`a',_N)
qui set obs `b'
qui drop if _n > `a'
local i = 1

tempname beba
matrix define `beba' = e(b)
local varlist: colnames `beba'
tokenize `varlist'
local varlist "`1'"
 

foreach x of local arguments {
qui replace `varlist' = `x' if _n == `i'
local i = `i' + 1
}
capture drop fit
capture drop fitse
capture drop lwr
capture drop upr
predict fit,xb
if("`predict'" == "") {
predict fitse,stdp
}
else {
predict fitse,stdf
}
gen lwr = fit - fitse*invttail(e(df_r),(1-(`level'/100))/2)
gen upr = fit + fitse*invttail(e(df_r),(1-(`level'/100))/2)
local a "%"
local a "`a'`length'"
local a "`a'.`precision'f"
format fit lwr upr `a'
l fit lwr upr
tempname result
mkmat `varlist' fit lwr upr, matrix(`result')
matrix colnames `result' = `varlist' fit lwr upr
return matrix result = `result'
restore
qui estimates restore `prevres'
end

