//version 1.0.0  21jan2008
program vselect,rclass
version 10.0
syntax varlist(numeric) [if] [in] [, BEST BACKward FORward R2ADJ AIC AICC BIC]
tempname prevest
capture estimates store prevest
if ("`best'" != "") {
	local x "backward forward r2adj aic aicc bic"
	foreach lname of local x {
		capture assert "``lname''" == ""
		if (_rc != 0) {
			di as error ///
"Option best may not be specified with any other options"
			exit 198
		}
	}
	leaps_and_bounds `varlist' `if' `in'
	local k = rowsof(r(info))
	forvalues i = 1/`k' {
		return local best`i' 	`"`r(best`i')'"'
	} 
	matrix a = r(info)
	return matrix info = a
	
}
else {
	if (("`backward'" == "" & "`forward'" == "") | ///
("`backward'" != "" & "`forward'" != "")) {
		di as error ///
"Must specify exactly one of Best Subsets (best) or Stepwise (forward, backward)"
	}
	local x "`r2adj' `aic' `aicc' `bic'"
	tokenize `x'
	capture assert "`1'" != "" & "`2'" == ""
	if (_rc != 0) {
		di as error ///
"May only specify 1 info. criteria when doing stepwise"
		exit 198
	}
	step_crit `0'
	return local predlist "`r(predlist)'"
}
capture estimates restore prevest
end
