//simple function that draws a scatter, or line plot of 
//given matrices (col vectors in this case)
//takes normal twoway options
program draw_matrix
version 10.0
syntax ,x(string) y(string) [line] [scatter] *
qui {
	tempname xlength ylength
	tempname xnu ynu
	tempvar vx vy
	preserve
	if ("`line'" == "" & "`scatter'" == "") {
		di as error "plot type not specified"
		exit 198
	}
	else if("`line'" != "" & "`scatter'" != "") {
		di as error "only one plot type may be specified"
		exit 198
	} 
	if (colsof(`x') != 1 | colsof(`y') != 1) {
		di as error "column vectors not passed in"
		exit 198
	}

	local `xlength' = rowsof(`x')
	local `ylength' = rowsof(`y')
	if(``xlength'' != ``ylength'') {
		di as error "x and y lists have different lengths"
		exit 198
	}
	drop _all	
	set obs ``xlength''

	matrix define `xnu'= `x'
	matrix define `ynu'= `y'
	svmat double `xnu', names("`vx'")
	svmat double `ynu', names("`vy'")

	if ("`line'" != "") {
		twoway line `vy' `vx', sort `options' 
	}
	else {
		twoway scatter `vy' `vx', `options'
	}
	restore
}
end
	
	
