// version 1.0.0  21jan2008
program irp, rclass
version 10
qui{
	syntax varlist(numeric) [if] [in] [, OPTimum TRY(numlist) old(name)] *
	preserve 
	tokenize `varlist'
	local totvar : word count `varlist'
	if (`totvar' <= 1) {
		di as error "Predictor and/or Response vars not specified."
		exit 198
	} 
		// set up y and yhat
	local y "`1'"
	capture assert `y' > 0
	if (_rc != 0) {
		di as error "Response variable not positive."
		exit 198
	}
	marksample touse
	markout `touse'
	count if `touse'
	local nobs = r(N)
	reg `varlist' if `touse'
	tempname yhatcoeff
	matrix `yhatcoeff' = e(b)	
	tempvar yhat
	predict `yhat', xb

	if ("`optimum'" != "") {
		//get optimum power and store it 
		tempname eoptimumpow
tempfile a
save `a'
keep if `touse'
	mata: powfcn("`y'", "`yhat'",-.5,"`eoptimumpow'")
use `a', clear

		tempvar optvar
		if (abs(`eoptimumpow') > 0.001) {
			gen `optvar' = `y'^`eoptimumpow'/`eoptimumpow'
		}
		else {
			gen `optvar' = ln(`y')
		}
		reg `yhat' `optvar' if `touse'
		tempname eoptimum
		matrix define `eoptimum' = J(1,4,.)
		matrix colnames `eoptimum' = power RSS intercept slope
		matrix `eoptimum'[1,1] = `eoptimumpow'
		matrix `eoptimum'[1,2] = e(rss)
		matrix `eoptimum'[1,3] = _b[_cons]
		matrix `eoptimum'[1,4] = _b[`optvar']
	}

	local tottry : word count `try'
	
	if ("`try'" != "") {
			//user supplied some guesses
		tempname tries
		matrix `tries' = J(`tottry',4,.)
		matrix colnames `tries' = power RSS intercept slope

		local i = 1
		foreach guess of local try {
			tempvar thisguess`i'
			if (`guess' != 0) {
				gen `thisguess`i'' = (`y'^`guess')/`guess'
			}
			if (`guess' == 0) {
				gen `thisguess`i'' = ln(`y')
			}
			reg `yhat' `thisguess`i'' if `touse'
			matrix `tries'[`i',1] = `guess'
			matrix `tries'[`i',2] = e(rss)
			matrix `tries'[`i',3] = _b[_cons]
			matrix `tries'[`i',4] = _b[`thisguess`i'']
			local i = `i' + 1
		}
	}

	local graphmac "twoway scatter `yhat' `y' if `touse'"

		//generate points for y to smooth 
		//power transformation plots
	tempvar original
	gen `original' = 1
	local a = _N + 100
	set obs `a'
	sum `yhat' if `touse'
	local yhatM = r(max)
	local yhatm = r(min)
	sum `y' if `touse'
	local yM = r(max)
	local ym = r(min)
	replace `original' = 0 if `original' == .
	sort `original'	
	assert `y' == . if `original' == 0
	replace `y' = _n*(`yM' - `ym')/100 + `ym' if `original' == 0
	local legendprep "Observed"
			
		//prepare fitted values for graphing
	if ("`optimum'" != "") {
		tempvar optfit
		if (abs(`eoptimum'[1,1]) > 0.001) {
			gen `optfit' = `eoptimum'[1,3] + ///
`eoptimum'[1,4]*(`y'^`eoptimum'[1,1]/`eoptimum'[1,1]) if `original' ==0
		}
		else {
			gen `optfit' = `eoptimum'[1,3] + ///
`eoptimum'[1,4]*ln(`y') if `original' ==0
		}
		local graphmac `"`graphmac' || line `optfit' `y' if `optfit' <= `yhatM' & `optfit' >= `yhatm'"'
		local tempstore = string(`eoptimum'[1,1],"%5.0g")
		local legendprep `"`legendprep' `tempstore'"' 
	}

	local i = 1
	foreach guess of local try {
		tempvar tryfit`i'
		if (abs(`tries'[`i',1]) > 0.001) {
			gen `tryfit`i'' = `tries'[`i',3] + ///
`tries'[`i',4]*(`y'^`tries'[`i',1]/`tries'[`i',1]) if `original' ==0
		}
		else {
			gen `tryfit`i'' = `tries'[`i',3] + ///
`tries'[`i',4]*ln(`y') if `original' ==0
		}
		local graphmac `"`graphmac' || line `tryfit`i'' `y' if `tryfit`i'' <= `yhatM' & `tryfit`i'' >= `yhatm'"'
		local tempstore = string(`tries'[`i',1],"%5.0g")
		local legendprep `"`legendprep' `tempstore'"' 
		local i = `i' + 1
	}
	
	if ("`old'" != "") {
		capture local rownum = rowsof(`old')
		if(_rc != 0) {
			di as error "Matrix name not passed as old."
			exit 198
		}
		capture assert `rownum' > 0
		if(_rc != 0) {
			di as error "Zero row matrix passed as old."
			exit 198
		}
		capture assert colsof(`old') == 4
		if(_rc != 0) {
			di as error "Matrix passed as old must have 4 columns."
			exit 198
		}
		capture assert matmissing(`old') == 0
		if(_rc != 0) {
			di as error "Missing values in matrix passed as old."
			exit 198
		}
			
		forvalues j = 1/`rownum' {
			tempvar tryfit`i'
			if (abs(`old'[`j',1]) > 0.001) {
				gen `tryfit`i'' = `old'[`j',3] + ///
			`old'[`j',4]*(`y'^`old'[`j',1]/`old'[`j',1]) ///
			if `original' ==0
			}
			else {
				gen `tryfit`i'' = `old'[`j',3] + ///
`old'[`j',4]*ln(`y') if `original' ==0
			}
			local graphmac `"`graphmac' || line `tryfit`i'' `y' if `tryfit`i'' <= `yhatM' & `tryfit`i'' >= `yhatm'"'
			local tempstore = string(`old'[`j',1],"%5.0g")
			local legendprep `"`legendprep' `tempstore'"' 
			local i = `i' + 1
		}	
	}

		//configure legend
		tokenize `legendprep'
//		local legendgraphmac  "legend(symxsize(2) size(vsmall) ring(1) position(2) cols(1) "
		local legendgraphmac  "legend(symxsize(2) size(small) ring(1) position(2) cols(1) "

		local totlegend : word count `legendprep'
		forvalues i = 1/`totlegend' {
			local legendgraphmac `"`legendgraphmac' label(`i' ``i'') "'
		}
		local legendgraphmac `"`legendgraphmac')"'


`graphmac', `legendgraphmac' ytitle("Fitted") `options'

	
		//return data to normal	
	restore
		
	tempname retmat
	matrix `retmat' = J(1,4,.)

	if ("`optimum'" != "") {
		return scalar optimum =`eoptimumpow'
		matrix `retmat' = (`retmat' \ `eoptimum')
	}
	if ("`try'" != "") {
		matrix `retmat' = (`retmat' \ `tries')
	}
	if ("`old'" != "") {
		matrix `retmat' = (`retmat' \ `old')
	}
	
	if (rowsof(`retmat') > 1) {
		local retmatsize = rowsof(`retmat')
		matrix `retmat' = `retmat'[2..`retmatsize',1..4]	
		matrix colnames `retmat' = Power RSS Intercept Slope
	//	return matrix tranres = `retmat'
	}

		//display results
	noi   di ""
	noi   di as text "{c TLC}{hline 10}{c TT}{hline 62}{c TRC}"
	local beb = abbrev("`y'",60)
	noi   di as text `"{c |} Response {c |} "' as result "`beb'" ///
 as text _col(75) "{c |}"
	local yhatnames : colnames `yhatcoeff'
	local ncoef = colsof(`yhatcoeff') - 1
	tokenize `yhatnames'
	forvalues j = 1/`ncoef' {
		local tempcoef = string(`yhatcoeff'[1,`j'],"%6.0g")
		local yhatlist `"`yhatlist'`tempcoef'*``j'' + "'
	}
	local ncoef = `ncoef' + 1
	local const = string(`yhatcoeff'[1,`ncoef'],"%6.0g")
	local yhatlist `"`yhatlist'`const'"' 

	local beb = substr("`yhatlist'",1,60)
	noi   di as text "{c LT}{hline 10}{c +}{hline 62}{c RT}"
	noi   di as text `"{c |}  Fitted  {c |} "' as result "`beb'" ///
as text _col(75) "{c |}"
	noi   di as text "{c BLC}{hline 10}{c BT}{hline 62}{c BRC}"
	noi di ""

	if ("`optimum'" != "") {
		noi di as text  "{c TLC}{hline 15}{c TT}{hline 11}{c TRC}" 
		noi di as text "{c |} Optimal Power"  " {c |} " ///
as result %9.0g `eoptimumpow' as text " {c |}"
		noi di as text  "{c BLC}{hline 15}{c BT}{hline 11}{c BRC}" 
	}
	else {
		noi di as text  "{c TLC}{hline 15}{c TT}{hline 30}{c TRC}" 
		noi di as text "{c |} Optimal Power {c |} " ///
as result "Not Calculated/Re-Calculated" as text " {c |}"
		noi di as text  "{c BLC}{hline 15}{c BT}{hline 30}{c BRC}" 
	}
	noi di ""

	if (rowsof(`retmat') > 0 & matmissing(`retmat') == 0) {
		noi di as text "{c TLC}{hline 11}{c TT}{hline 14}{c TRC}" 	
		noi di as text "{c |}    Power" _col(13) ///
"{c |} RSS( F | R ) {c |}" 
		noi di as text "{c LT}{hline 11}{c +}{hline 14}{c RT}" 
		local nrows = rowsof(`retmat')
		forvalues i = 1/`nrows' {
			noi di as text "{c |} " as result %9.0g ///
`retmat'[`i',1] as text _col(13) "{c |} " as result %9.0g ///
`retmat'[`i',2] as text _col(28) "{c |}"   
		}	
		noi di as text "{c BLC}{hline 11}{c BT}{hline 14}{c BRC}" 	
	}
	else {
		noi di as result "No Transformation Calculations Made."
	}
	
	return matrix tranres = `retmat'

}
end




mata:

real scalar RssCalc(real scalar v, real matrix Y) 
{
	real matrix fit
	real matrix inmediares
	if (v == 0) {
		fit = ln(Y[,1])
	}
	else {
			fit = ((Y[,1]:^ v) :- 1) :/ v
	}
	inmediares = Y[,2] - (fit , J(rows(Y[,1]),1,1)) * ///
(luinv(cross(fit,1,fit,1))) * cross(fit,1,Y[,2],0)
	return (inmediares'*inmediares)
}

void mieval(todo,p,z,y,g,H)
{
	y = -RssCalc(p,z)
}

// Get estimate of power trans.
void powfcn(string scalar y, string scalar yhat,real scalar guess, ///
string scalar putin)
{
	st_view(X=.,.,(y,yhat))
	S = optimize_init()
	optimize_init_evaluator(S,&mieval())
	optimize_init_params(S,guess)
	optimize_init_argument(S,1,X)
	p = optimize(S)
	st_numscalar(putin,p)
}
end










