{smcl}
{* *! version 1.0.0  21jan2008}{...}
{cmd:help irp} 
{hline}

{title:Title}

{p2colset 5 15 22 2}{...}
{p2col :{hi:irp} {hline 2}}Inverse Response Plots{p_end}
{p2colreset}{...}


{title:Syntax}

{p 8 16 2}
{cmd: irp} {depvar} {indepvars} {ifin} [{cmd :,} {it:options}]

{synoptset 27 tabbed}{...}
{synopthdr}
{synoptline}
{syntab:Main}
{synopt : {opt opt:imum}} calculate optimal transformation {p_end}
{synopt : {opt try:}{bf}({it}{help numlist}){sf}}  transformations to try {p_end}

{syntab:Other Options}
{synopt : {opt old:}(name)} previous results to use {p_end}
{synopt :{it:{help twoway_options}}} any of the options documented in {bind:{bf:[G]} {it:twoway_options}}{p_end}
{synoptline}
{p2colreset}{...}
{p 4 6 2}


{title:Description}

{pstd}

For positive {depvar},{cmd:irp} renders the inverse response plot of {depvar} on {indepvars}.  
This gives a graphical view of the gain in linearization between {depvar} and {indepvars} for certain scaled 
power transformations of {depvar}.  If a rendered transformation curve fits the points well, then transforming
{depvar} with that power will yield a linear relationship between {depvar} and {indepvars}.

For{cmd:irp} to be valid, certain conditions on {indepvars} must be met.
If there just one variable in {indepvars}, it should be symetric and continous.  This can be
checked with {helpb kdensity} or {helpb qnorm}.  If there are multiple variables in {indepvars}, 
they should approximately linearly related.  This can be checked with {helpb graph matrix}.

{title:Options}

{dlgtab:Main}

{phang}
{opt opt:imum} specifies that {cmd: irp} will find the best transformation by a numerical optimization.

{phang}
{opt try:}{bf}({it}{help numlist} min=1{bf}){sf} draws the given transformation powers in the plot.  

{dlgtab:Other Options}

{phang}
{opt old:}(name) uses the previously calculated results stored in the named matrix. These results are drawn in the plot and not recalculated.

{phang}
{it:twoway_options} are any of the options documented in 
{manhelpi twoway_options G}.  These include options for titling the graph 
(see {manhelpi title_options G}), options for saving the graph to disk (see 
{manhelpi saving_option G}), and the {opt by()} option (see 
{manhelpi by_option G}).

{title:Examples}

. {stata "sysuse auto"}

. {stata graph matrix mpg weight gear_ratio}

. {stata irp mpg weight gear_ratio, opt}

. {stata matrix b = r(tranres)}

. {stata irp mpg weight gear_ratio, try(-1) old(b)}

{title:Saved results}

{pstd}
{cmd:irp} saves the following in {cmd:r()}:

{synoptset 15 tabbed}{...}
{p2col 5 15 19 2: Matrices}{p_end}
{synopt:{cmd:r(tranres)}} 2 column matrix with one row per tranformation power.  Transformation power is stored in the first column.  The second colum stores the residual sum of squares from the regression of the fitted values from {indepvars} 
					on the transformed {depvar}.  A smaller value in the second column means a better linearization.
{p2colreset}{...}
