// version 1.0.0  21Jan2008
program mboxcox, eclass
	version 10
qui{
	if !replay() {
		syntax varlist(numeric) [if] [in] [, Level(cilevel)]

						// set used sample
		marksample touse
	      markout `touse'
		count if `touse'
						//count it for later posting
		local nobs = r(N)

                        //ensure varlist is specified correctly
                foreach var of varlist `varlist' {
			
                        count if `var' <= 0 & `touse'
                        if (r(N) > 0) {
                                di as error "`var' has non-positive values."
                                exit 198
                        }
                }


	
			//save number variables as df for later tests
		local df: word count `varlist'

			//declare tempnames for later posting
			//power estimate row vector
		tempname b   
			//covariance of powers matrix
		tempname V
			//scalar lrt test stat for all powers = 0
		tempname lrt_stat_0
			//scalar lrt test stat for all powers = 1
		tempname lrt_stat_1
			//scalar lrt test stat for all powers = -1
		tempname lrt_stat_n1
			//scalar p value for lrt_stat_0
		tempname ll_0
			//scalar log likelihood under all 1
		tempname ll_1
			//scalar log likelihood under all -1
		tempname ll_n1
			//fill tempnames out
		preserve
		keep if `touse'
		keep `varlist'
		order `varlist'
		mata: _bc_multi_setupoptim_lrt("`b'","`V'","`lrt_stat_0'", ///
"`lrt_stat_1'","`lrt_stat_n1'","`ll_0'","`ll_1'","`ll_n1'")

		local nlist 
		foreach v of local varlist {
			local nlist `nlist' lambda:`v'
		}

		matrix colnames `b' = `nlist'
		matrix list `b'
		matrix colnames `V' = `nlist'
		matrix rownames `V' = `nlist'
		matrix list `V'
		restore 
		ereturn post `b' `V', obs(`nobs') esample(`touse')
		ereturn scalar ll0 = `ll_0'
		ereturn scalar ll1 = `ll_1'
		ereturn scalar lln1 = `ll_n1'
		ereturn scalar lrt0 = `lrt_stat_0'
		ereturn scalar lrt1 = `lrt_stat_1'
		ereturn scalar lrtn1 = `lrt_stat_n1'
		
		ereturn local cmd = "mboxcox"
	}
	else { // replay
		if "`e(cmd)'" != "mboxcox" error 301
		syntax [, Level(cilevel)]
	}
}
	bc_multi_Display, level(`level')
end

program bc_multi_Display
	syntax [, Level(cilevel)] 
	tempname A
	matrix define `A' = e(b) 
	local df = colsof(`A')
	local p0 = 1-chi2(`df',e(lrt0))
	local p1 = 1-chi2(`df',e(lrt1))
	local pn1 = 1-chi2(`df',e(lrtn1))
	
	display "{txt}Multivariate boxcox transformations"

	display "{txt}{col 51}Number of obs{col 67}=" 		///
		as res _col(71) %8.0f e(N)
	
	di ""
        di as text "Likelihood Ratio Tests"
        di as text "{hline 13}{c TT}{hline 64}"
	di as text "Test         " "{c |}" "  "  "Log Likelihood" _col(35) ///
" Chi2"  _col(50) "df"  _col(65)  "Prob > Chi2" 
        di as text "{hline 13}{c +}{hline 64}
	di as text "All powers -1" "{c |}" as result  " " %9.0g e(lln1) ///
_col(35) %9.0g e(lrtn1) _col(50) `df' _col(65)  `pn1'
	di as text "All powers  0" "{c |}" as result  " " %9.0g e(ll0) ///
_col(35) %9.0g e(lrt0) _col(50)  `df' _col(65)  `p0'
	di as text "All powers  1" "{c |}" as result  " " %9.0g e(ll1) ///
_col(35) %9.0g e(lrt1) _col(50)  `df' _col(65)  `p1'
        di as text "{hline 13}{c BT}{hline 64}
	di ""
	ereturn display, level(`level')
end



mata:
// log Likelihood optimization function
void _bc_multi_loglkmax(todo, lambda,X,GMX,lnf,g,H)
{
        real matrix Y
        Y = X
        for(i = 1; i <= cols(X); i++)
        {
                if (lambda[,i] == 0)
                {
                        Y[,i] = GMX[,i]:*ln(Y[,i])
                }
                else
                {
                        Y[,i] = (GMX[,i] :* (GMX[,i] :^(-lambda[,i]))) ///
:* (((Y[,i] :^ lambda[,i]) :- 1) :/ lambda[,i])
                }
        }
        lnf = -(rows(X)/2)*ln(det(variance(Y)))
}

// simplified log Likelihood function
real scalar _bc_multi_loglkhood(lambda,X)
{
       real matrix GMX
        GMX = exp(colsum(ln(X)) :/ rows(X))
        real matrix Y
        Y = X
        for(i = 1; i <= cols(X); i++)
        {
                if (lambda[,i] == 0)
                {
                        Y[,i] = GMX[,i]:*ln(Y[,i])
                }
                else
                {
                        Y[,i] = (GMX[,i] :* (GMX[,i] :^(-lambda[,i]))) :* ///
				(((Y[,i] :^ lambda[,i]) :- 1) :/ lambda[,i])
                }
        }
		if (det(variance(Y)) < .000005)	{
			stata("di as error " + char(34) + ///
"Sample Covariance of Transformed Data is nearly singular.") 
			stata("di as error " + char(34) + ///
"Cannot compute Likelihood.") 
		}
        return(-(rows(X)/2)*ln(det(variance(Y))))
}

void _bc_multi_setupoptim_lrt( string scalar coef,string scalar var, ///
string scalar lrt_stat_0, string scalar lrt_stat_1, ///
string scalar lrt_stat_n1, string scalar ll_0, string scalar ll_1, ///
string scalar ll_n1)
{
        X = st_data(.,.)
                //geometric mean vector
        GMX = exp(colsum(ln(X)) :/ rows(X))
                //obtain mle of transformation powers
        S = optimize_init()
        optimize_init_evaluator(S,&_bc_multi_loglkmax())
        optimize_init_params(S,J(1,cols(X),0))
        optimize_init_argument(S,1,X)
        optimize_init_argument(S,2,GMX)
        lambda_mle = optimize(S)
        lambda_mle
        V = optimize_result_V_oim(S)
        lambda_se = diagonal(V) :^ (1/2)
        lambda_se
	st_matrix(coef,lambda_mle)
	st_matrix(var,V)
  	B = lambda_mle
		//calculate LRT
	LRT_mat = (B :* 0) \ ((B :* 0) :+ 1)  \ ((B :* 0) :- 1) 
	LRT_mat
	LRT_stat = J(3,1,0)
		ll0 = _bc_multi_loglkhood(LRT_mat[1,],X)
		ll1 = _bc_multi_loglkhood(LRT_mat[2,],X)
		lln1 = _bc_multi_loglkhood(LRT_mat[3,],X)
		ml = 	_bc_multi_loglkhood(B,X)


        LRT_stat[1,] = 2*(ml-ll0)
        LRT_stat[2,] = 2*(ml-ll1)
        LRT_stat[3,] = 2*(ml-lln1)

	st_numscalar(lrt_stat_0,LRT_stat[1,1])
	st_numscalar(lrt_stat_1,LRT_stat[2,1])
	st_numscalar(lrt_stat_n1,LRT_stat[3,1])
	st_numscalar(ll_0,ll0)
	st_numscalar(ll_1,ll1)
	st_numscalar(ll_n1,lln1)
}


end
