{smcl}
{* *! version 1.0.0  21jan2008}{...}
{cmd:help mmp} 
{hline}

{title:Title}

{p2colset 5 15 22 2}{...}
{p2col :{hi:mmp} {hline 2}}Marginal Model Plots{p_end}
{p2colreset}{...}


{title:Syntax}

{p 8 16 2}
{cmd: mmp} {cmd :,} [{it:options}]

{synoptset 27 tabbed}{...}
{synopthdr}
{synoptline}
{syntab:Calculation}
{synopt : {opt m:ean}(string)} option for {helpb predict} to use to generate expectation{p_end}
{synopt : {opt smo:other}(string)} smoother to use for generating {it:model} and {it:alternative} lines{p_end}
{synopt : [{opt smoopt:ions}(string)]} options for smoother{p_end}

{syntab:Which Plots to Produce}
{synopt : [{opt lin:ear}]} render a marginal model plot for the linear x'e(b) form{p_end}
{synopt : [{opt pred:ictors}]} render marginal model plots for all predictors{p_end}
{synopt : [{opt var:list}{bf}({it}{help varlist}{bf}){sf}]} render marginal model plots for the selected predictors{p_end}

{syntab:Graphic Options}
{synopt : [{opt indg:options}(string)]} options for individual marginal model plots{p_end}
{synopt : [{opt gopt:ions}(string)]} options for combined plot{p_end}

{synoptline}
{p2colreset}{...}
{p 4 6 2}


{title:Description}

{pstd}

Draws the specified marginal model plots after a generalized linear model is estimated.
These plots assess how well the model estimates the mean of the response, conditional on 
the predictors.  A marginal model plot has three overlaid components.  

The first is a scatterplot of a variable or linear combination of predictors on the horizontal 
axis versus the response on the vertical axis.  

Then a smoother is used to estimate the response based on the horizontal quantity.  This
yields the {it:alternative} line.  This is rendered in blue.

The third component is obtained by using the smoother to estimate the conditional mean of 
the fitted prediction of the response, based on the horizontal quantity.  This yields the 
{it:model} line.  This will be rendered as a red dashed line.

A marginal model plot should be generated for each continuous predictor in the model, and the 
linear x'e(b) form.  The estimated model is a good fit if the red and blue lines match well. 

{title:Options}

{dlgtab:Calculation}

{phang}
{opt m:ean(string)} tells {cmd:mmp} what options to pass to {helpb predict} to estimate the response based on the predictors.  
For linear regression, it would be "xb".  For logistic regression, it would be "pr".

{phang}
{opt smo:other(string)} uses the specified smoother to draw the {it:model} and {it:alternative} lines.  Smoother must have a {it:generate} option, which takes a single argument.

{phang}
{opt smoopt:ions(string)} performs the smoothing with the specified options.

{dlgtab:Which Plots to Produce}

{phang}
{opt lin:ear} draws marginal model plot with horizontal quantity linear x'e(b) form.

{phang}
{opt pred:ictors} draws marginal model plots for each of the predictors in the model.

{phang}
{opt var:list}({it}{help varlist}{sf}) draws marginal model plots for each of the specified variables. This option is ignored if {opt pred:ictors} is used.

{dlgtab:Graphic Options}

{phang}
{opt indg:options}(string) draws individual marginal model plots with the specified {helpb twoway_options} applied to each plot.

{phang}
{opt gopt:ions}(string) draws marginal model plots with the specified {helpb graph combine} options applied to the combined graphic.

{title:Examples}

. {stata "sysuse auto"}

. {stata reg mpg weight foreign}

. {stata mmp, mean(xb) smoother(lowess) lin pred smoopt(bwidth(.66))}

. {stata gen weight2 = weight^2}

. {stata reg mpg weight weight2 foreign}

. {stata mmp, mean(xb) smoother(lowess) lin pred smoopt(bwidth(.66))}
