//plots                 profile log_likelihood of response transformation 
// arguments            varlist         (depvar followed by indepvars)
//                      [if] [in]       
//specifications for range of transformation data
//                      level           confidence level of ci to use
//                      plotspts        
// number of points to calculate log likelihood at
//                      window          
//left and right hand endpoints of plot window
// returns:     
// plots log likelihood using scale family transformation 
// w/geometric mean adjustment
program plot_bc
version 10.0
syntax varlist [if] [in], Level(cilevel) plotpts(numlist min=1 max=1 >0) window(numlist min=2 max=2) *
qui {
	preserve
	if ("`if'" != "") {
		local ifin "if `if'"
	}
	if ("`in'" != "") {
		local ifin "`ifin' in `in'"
	}

        tokenize `window'
	if (`1' > `2') {
		di as error "plot window invalid"
		exit 198
	}


	tempvar lambda
	tempname bob
	boxcox `varlist' `ifin', model(lhsonly) 
	drop _all
	tempname pe

        // store boxcox estimates for point estimate
        local `pe' = r(est)

	local `bob' = trunc(`plotpts') 
	range `lambda' `window' ``bob''
	tempname obs
	local `obs' = _N + 1
	set obs ``obs''
	replace `lambda' = ``pe'' if _n == _N
	// names estimate positions
	tempvar estmark
	gen `estmark' = ``pe'' if _n == _N
	tempname matlambda 
	mkmat `lambda',matrix(`matlambda')
	restore
	preserve
		//store geometric mean of y
	tempvar ly
	tokenize `varlist'
	gen `ly' = ln(`1')
	sum `ly'
	tempname ym
	local `ym' = exp(r(mean))

	if (`"`ifin'"' != "" ) {
		keep if `ifin'
	}
	tempname matlkhood
	matrix define `matlkhood' = `matlambda'
	tempname estlkhood
	tempname cilkhood

	tempvar holder
	gen `holder' = .
	forvalues i = 1/``obs'' {
			// fill in loglkhood matrix
		replace `holder' = `1'
		if (`matlambda'[`i',1] != 0)  {
			replace  `1' = ///
(`1'^(`matlambda'[`i',1]) - 1)/(`matlambda'[`i',1])
		}
		else {
                        replace  `1' = ln(`1')
		}
		replace `1' = `1'/(``ym''^(`matlambda'[`i',1] - 1))
		reg `varlist'
		matrix `matlkhood'[`i',1] = -_N/2 * ln(`e(rss)')
		replace `1' = `holder'
	}


	drop _all
	svmat double `matlambda', names("`lambda'")
	tempvar loglkhood
	svmat double `matlkhood', names("`loglkhood'")



	//set up likelihood interval
	tempvar estloglkhood
	tempvar estmark
	gen `estmark' = `lambda'[_N] 
	gen `estloglkhood' = `loglkhood'[_N] if _n == _N
	sum `loglkhood'
	replace `estloglkhood' = min(r(min), r(max) - invchi2(1,.95)/2) ///
if `estloglkhood' == .
	tempvar ciloglkhood
	gen `ciloglkhood' = r(max) - invchi2(1,.95)/2
	sort `lambda'
	tempvar cimark1 cimark2
	gen `cimark1' = `lambda' ///
if `loglkhood' >= `ciloglkhood' & `loglkhood'[_n-1] < `ciloglkhood'
	gen `cimark2' = `lambda' ///
if `loglkhood' >= `ciloglkhood' & `loglkhood'[_n+1] < `ciloglkhood'
	sum `loglkhood'
	tempvar civertlkhood1
	gen `civertlkhood1' = min(r(min), r(max) - invchi2(1,.95)/2) ///
if `cimark1' == . 
	replace `civertlkhood1' = `ciloglkhood' if `civertlkhood1' == .
	sum `loglkhood'
        tempvar civertlkhood2
        gen `civertlkhood2' = min(r(min), r(max) - invchi2(1,.95)/2) ///
if `cimark2' == .
        replace `civertlkhood2' = `ciloglkhood' if `civertlkhood2' == .
	sum `estmark'
	replace `estmark' = r(min) if `estmark' == .
	sum `cimark1'
	replace `cimark1' = r(min) if `cimark1' == .
	sum `cimark2'
	replace `cimark2' = r(min) if `cimark2' == .

	tokenize `window'
	twoway line `loglkhood' `lambda', lcol(black) sort || /// 
	line `ciloglkhood' `lambda', lcol(red) sort lpattern(dash) || ///
	line `estloglkhood' `estmark' , lcol(red) sort lpattern(dash) || ///
	line `civertlkhood1' `cimark1', lcol(red) sort lpattern(dash) || ///
	line `civertlkhood2' `cimark2', lcol(red) sort lpattern(dash) ///
	xtitle("lambda") ytitle("log-Likelihood") legend(off) `options'
restore

}
end
