do{smcl}
{* *! version 1.0.0  21jan2008}{...}
{cmd:help vselect} 
{hline}

{title:Title}

{p2colset 5 25 22 2}{...}
{p2col :{hi:vselect} {hline 2}}Linear Regression Variable Selection {p_end}
{p2colreset}{...}

{title:Syntax}

{p 8 16 2}
{cmd: vselect} {depvar} {indepvars} {ifin} [{cmd :,} {it:options}]

{synoptset 27 tabbed}{...}
{synopthdr}
{synoptline}
{syntab:Algorithm}
{synopt : {opt best:}} give the best model for each quantity of predictors{p_end}
{synopt : {opt back:ward}} select a model by backward elimination{p_end}
{synopt : {opt for:ward}} select a model by forward selection{p_end}

{syntab:Information Criteria}
{synopt : {opt r2adj:}} use R^2 Adjusted information criterion in selection{p_end}
{synopt : {opt aic:}}  use Akaike's information criterion in selection{p_end}
{synopt : {opt aicc:}}  use Akaike's corrected information criterion in selection{p_end}
{synopt : {opt bic:}}  use Bayesian information criterion in selection{p_end}

{synoptline}
{p2colreset}{...}
{p 4 6 2}

{title:Description}

{pstd}

{cmd:vselect} performs variable selection for linear regression.  Through the use of the 
Furnival-Wilson Leaps-and-Bounds algorithm, all subsets variable selection is supported.  
This is done when the user specifies the {it:best} option.  The stepwise methods, forward 
selection and backward elimination are also supported 
(by specifying {it:forward} or {it:backward}).

All subsets variable selection provides the R^2 Adjusted, AIC, AICC, and BIC information 
criteria for the best regression at each quantity of predictors.  For stepwise selection, 
the user must tell {cmd:vselect} which information criteria to use.  

{title:Examples}

. {stata sysuse auto}

. {stata regress mpg weight trunk length foreign}

. {stata vselect mpg weight trunk length foreign, best}

. {stata vselect mpg weight trunk length foreign, forward aicc}

. {stata vselect mpg weight trunk length foreign, backward bic}

{title:Saved results}

{pstd}
{cmd:mboxcox} saves the following in {cmd:r()}:

{synoptset 25 tabbed}{...}
{p2col 5 25 29 2: Macros (best)}{p_end}
{synopt:{cmd:r(bestK)}}variable list of predictors from best K predictor model{p_end}
{synopt:.}{p_end}
{synopt:.}{p_end}
{synopt:{cmd:r(besti)}}variable list of predictors from best i predictor model{p_end}
{synopt:.}{p_end}
{synopt:.}{p_end}
{synopt:{cmd:r(best1)}}variable list of predictors from best 1 predictor model{p_end}


{p2col 5 25 29 2: Macros (forward/backward)}{p_end}
{synopt:{cmd:r(predlist)}}variable list of predictors from optimal model{p_end}


{p2col 5 25 29 2: Matrices (best)}{p_end}
{synopt:{cmd:r(info)}}contains the information criteria for the best models.{p_end}
{p2colreset}{...}
