function J = JPro(pi)
% Jsip: obj. function of observation error minimization for TDOA
% localization, using SIP method
% pi: 2 by 3. positions of beacons
% y: TODA inputs
% p is a constant now
% min_{p_i} the cov(\hat p) 
% domain [0 1]*[0 1]
%
% Zhen Song
% zhensong@ieee.org
% 7/2006

global p; %p, const now
global B; % transfer B to JsipCont in order to save computations
global StaticP;

if size(pi,1)~=2
    BeaconN=size(pi,1)/2;
    pi=reshape(pi,2,BeaconN);
else
    BeaconN=size(pi,2);
end

% B will be cov(\hat p)
B=zeros(2,2);

StaticN=size(StaticP,2);

for ind=2:StaticN
    vec= norm(p-StaticP(:,1))^(-1)*(p-StaticP(:,1)) - norm(p-StaticP(:,ind))^(-1)*(p-StaticP(:,ind));
    B=B+(vec * vec');    
end

for ind=2:BeaconN
    vec= norm(p-pi(:,1))^(-1)*(p-pi(:,1)) - norm(p-pi(:,ind))^(-1)*(p-pi(:,ind));
    B=B+(vec * vec');
end
% D-opt 
J=-log(det(B));