function ans=isInDomain(pos, domid, varargin)
% inDomain: if return -1 in the associated position is inside the domain, otherwise return 1
% pos: positions of several 2D points. Could be 2 by n, or 2*n by 1.
% domid: the id of domains.

if (size(pos,2)==1)
    num=size(pos,1)/2;
else
    num=size(pos,2);    
end
ans=-1*ones(num,1);

if ~isempty(varargin)
    if strcmp(lower(varargin{1}), 'plot')
        switch domid
            case 1
                ans=line([0 1 1 0 0], [0 0 1 1 0],varargin{2:end});
                hold on;
            case 2
                ans=line([0 0.5 0.5 0 0], [0 0 1 1 0],varargin{2:end});
                hold on;
            case 3
                ans=zeros(2,1);
                ans(1)=line([0.5 0 0 0.5], [0 0 1 1],varargin{2:end});
                hold on;
                omega=linspace(-3.14/2, 3.14/2);
                cirpt=[cos(omega)*0.5+0.5; sin(omega)*0.5+0.5];
                ans(2)=plot(cirpt(1,:),cirpt(2,:),varargin{2:end});               
            case 4
                ans=line([0 0.4 0.4 0.6 0.6 1 1 0 0], [0 0 0.6 0.6 0 0 1 1 0],varargin{2:end} );
                hold on;
            case 5
                ans=zeros(2,1);
                ans(1)=line([0.4 0.4 0.6 0.6 0.4], [0.6 0.4 0.4 0.6 0.6],varargin{2:end});      
                hold on;
                ans(2)=line([0 1 1 0 0], [0 0 1 1 0],varargin{2:end});
        end
        axis([0 1 0 1]); axis equal;
    end
else
    switch domid
        case 1
            % square area, the most simple case
            for ind=1:num
                if (pos(1,ind)>=0 & pos(1,ind)<=1 & pos(2,ind)>=0 & pos(2,ind)<=1) %in the domain
                    ans(ind)=-1;
                else
                    ans(ind)=1;
                end
            end
        case 2
            % rectangle area
            for ind=1:num
                x=pos(1,ind); y=pos(2,ind);
                if (x>=0 & x<=0.5 & y>=0 & y<=1) % in the domain
                    ans(ind)=-1;
                else
                    ans(ind)=1;
                end
            end
        case 3
            % unfinished
        case 4
            % C-shape area
            for ind=1:num
                x=pos(1,ind); y=pos(2,ind);
                if (x>0.4 & x<0.6 & y<0.6)  ... % in the hole
                        | (x<0 | x>1 | y<0 | y>1 ) % out of the region
                    ans(ind)=1; %
                else
                    ans(ind)=-1;
                end
            end        
        case 5
            % square with a whole
            for ind=1:num
                x=pos(1,ind); y=pos(2,ind);
                if (x>0.4 & x<0.6 & y>0.4 & y<0.6)  ... % in the hole
                        | (x<0 | x>1 | y<0 | y>1 ) % out of the region
                    ans(ind)=1; %
                else
                    ans(ind)=-1;
                end
            end                
        otherwise
    end
end

return;