function [eventPosHat, rLS, SenST, EllipseMat]= LSfindPos2(SenPos, k, S, sind, sigmaSqForOneSensor);
% Least-square based event position estimation
% Return confidence ellipse
    step = 0.1; % step size for gradient-base convertence

    err=[];
    it = 1;
    eventPosHat=[0;0];    % init position value 
    SenN = size(SenPos,2);
    sigma=(sigmaSqForOneSensor^(-2))*eye(SenN,SenN);
        
    while it<100
        grad = zeros(2,1);
        for cnt2 = 1:length(sind)
            cnt = sind(cnt2);
            SenST(cnt,:)=(2/k)*exp(-norm(SenPos(:,cnt)-eventPosHat)^2/k)*(SenPos(:,cnt)-eventPosHat)';
            ytmp = exp(-norm(SenPos(:,cnt)-eventPosHat)^2/k);
            grad = grad + (ytmp-S(cnt))*SenST(cnt,:)';
        end
        % make sure SenST has enough entries
        if size(SenST,1)<size(SenPos,2)
            padnum = size(SenPos,2)-size(SenST,1);
            SenST = [SenST; zeros(padnum, 2)];
        end
        
        NewEventPosHat=eventPosHat - step*grad;

        err=[err norm(NewEventPosHat-eventPosHat)];                    
        if abs(err(end))<0.01;
            break;
        end  
        
        eventPosHat = NewEventPosHat;
        it = it+1;
    end    
    % draw a error circle
    rLS=0;
    M=zeros(2,2);
    for cnt2 = 1:length(sind)
        cnt = sind(cnt2);
        LSfim(:,:,cnt)=SenST(cnt,:)'*SenST(cnt,:)*sigma(cnt,cnt);
        M=M+LSfim(:,:,cnt);
    end
    % find the mean of M
    M=M/length(sind);
    rLS = trace(inv(M))^(0.5);
    EllipseMat = inv(M)^(0.5);
%     EllipseMat = (M).^(0.5);