function w=fCvxElim(B, w, tolerance)
% wo=fCvxElim(B, w, tolerence)
% p=B*w, where p is a k by 1 vector; B is a k by n matrix; w is a n by 1
% vector. The output wo is a n by 1 vector, which is the convex elimination
% of w.
% 

% n=2; k=1; % k is replaced by m in the note
k=size(B,1);
n=size(B,2);

if tolerance <= 0
    ep=1e-3;
else
    ep = tolerance;
end

N=TransReduceHead(n)*null(B*TransReduceHead(n));
nc=size(N,2);

for col=1:nc
    ncol=N(:,col);
    pInd=find(ncol>ep);
    wn=w(pInd)./ncol(pInd);
    alp=min(wn);
    ind=find(wn==alp);
    ind=pInd(ind(1)); % global index
    Z= eye(nc); % Matrix for column elimation
    Z(col,col+1:end)=-N(ind,col+1:end)/ncol(ind);
    N=N*Z;
    w=w-alp*ncol;
end

% ncol=N(:,end);
% pInd=find(ncol>ep);
% v=pInd';
% 
% wn=w(pInd)./ncol(pInd);
% alp=min(wn);
% w=w-alp*ncol; 

return