function [c,ceq,K,picont,s] = JsipCont(pi,s)
% JsipCont: min max opt. for TDOA beacon placement
% Zhen Song


global p;
global ConstraintDomain;
global B; 

if size(pi,1)~=2
    BeaconN=size(pi,1)/2;
    pi=reshape(pi,2,BeaconN);
else
    BeaconN=size(pi,2);
end

% B will be cov(\hat p)
B=zeros(2,2);
for ind=2:BeaconN
    vec= norm(p-pi(:,1))^(-1)*(p-pi(:,1)) - norm(p-pi(:,ind))^(-1)*(p-pi(:,ind));
    B=B+(vec * vec');
end
% D-opt 
alpha=-log(det(B));

switch ConstraintDomain
    case 1
        Len=100;
        xyaxis=linspace(0,1,Len); % constraints on p
        [px,py]=meshgrid(xyaxis,xyaxis);
        Dmat=zeros(Len,Len);
        for row=1:Len
            for col=1:Len
                ptmp=[px(row); py(col)];
                M=zeros(2,2);
                for ind=2:3
                    vec=norm(ptmp-pi(:,1))^(-1)*(ptmp-pi(:,1)) - norm(ptmp-pi(:,ind))^(-1)*(ptmp-pi(:,ind));
                    M=M+(vec*vec');
                end
                Dmat(row,col)=-log(det(M));
            end
        end
        K=Dmat-ones(Len,Len)*alpha;
        % constraints on variable domain
        picont = isInDomain(pi,ConstraintDomain);        
        allxy=reshape(pi,6,1);
        c=[-allxy; allxy-ones(6,1)];
        ceq=[];
    case 2
        % [0 0.5]*[0 1]
        Len=100;
        xyaxis=linspace(0,1,Len); % constraints on p
        [px,py]=meshgrid(xyaxis,xyaxis);
        Dmat=zeros(Len,Len);
        for row=1:Len
            for col=1:Len
                ptmp=[px(row); py(col)];
                if px(row)>0.5
                    % make sure this entry of K is always negative
                    Dmat(row,col)=alpha-1; 
                else
                    M=zeros(2,2);
                    for ind=2:3
                        vec=norm(ptmp-pi(:,1))^(-1)*(ptmp-pi(:,1)) - norm(ptmp-pi(:,ind))^(-1)*(ptmp-pi(:,ind));
                        M=M+(vec*vec');
                    end
                    Dmat(row,col)=-log(det(M));
                end
            end
        end
        K=Dmat-ones(Len,Len)*alpha;
        % constraints on variable domain
        picont = isInDomain(pi,ConstraintDomain);
        allxy=reshape(pi,6,1);
        % x\in[0,0.5] y\in[0,1]
        ub=[repmat([0.5; 1] ,3,1)];
        c=[-allxy; allxy-ub];
        ceq=[];        
    case 3
        % [0 0.5]*[0 1]+semi-circle
        Len=100;
        xyaxis=linspace(0,1,Len); % constraints on p
        [px,py]=meshgrid(xyaxis,xyaxis);
        Dmat=zeros(Len,Len);
        for row=1:Len
            for col=1:Len
                ptmp=[px(row); py(col)];
                if px(row)>0.5 & norm(ptmp-[0.5; 0.5])>0.5
                    % make sure this entry of K is always negative
                    Dmat(row,col)=alpha-1; 
                else
                    M=zeros(2,2);
                    for ind=2:3
                        vec=norm(ptmp-pi(:,1))^(-1)*(ptmp-pi(:,1)) - norm(ptmp-pi(:,ind))^(-1)*(ptmp-pi(:,ind));
                        M=M+(vec*vec');
                    end
                    Dmat(row,col)=-log(det(M));
                end
            end
        end
        K=Dmat-ones(Len,Len)*alpha;
        % constraints on variable domain
        picont = isInDomain(pi,ConstraintDomain);        
        allxy=reshape(pi,6,1);
        c=[-allxy; allxy-ones(6,1)];
        ceq=[];                
    case 4
        % [0 0.5]*[0 1] - [0.4 0.6]*[0 0.6]
        Len=100;
        xyaxis=linspace(0,1,Len); % constraints on p
        [px,py]=meshgrid(xyaxis,xyaxis);
        Dmat=zeros(Len,Len);
        for row=1:Len
            for col=1:Len
                ptmp=[px(row); py(col)];
                if ( px(row)>0.4 & px(row)<0.6) & (py(col)<0.6)
                    % make sure this entry of K is always negative
                    %                     Dmat(row,col)=alpha-1; 
                else
                    M=zeros(2,2);
                    for ind=2:BeaconN
                        vec=norm(ptmp-pi(:,1))^(-1)*(ptmp-pi(:,1)) - norm(ptmp-pi(:,ind))^(-1)*(ptmp-pi(:,ind));
                        M=M+(vec*vec');
                    end
                    Dmat(row,col)=-log(det(M));
                end
            end
        end
        K=Dmat-ones(Len,Len)*alpha;
        % constraints on variable domain
        picont = isInDomain(pi,ConstraintDomain);
        
        allxy=reshape(pi,BeaconN*2,1);
        c=[-allxy; allxy-ones(BeaconN*2,1)];
        ceq=[];    
    case 5
        % [0 0.5]*[0 1] - [0.4 0.6]*[0 0.6]
        Len=100;
        xyaxis=linspace(0,1,Len); % constraints on p
        [px,py]=meshgrid(xyaxis,xyaxis);
        Dmat=zeros(Len,Len);
        for row=1:Len
            for col=1:Len
                ptmp=[px(row); py(col)];
                x=ptmp(1); y=ptmp(2);
                if (x>0.4 & x<0.6 & y>0.4 & y<0.6)  ... % in the hole
                        | (x<0 | x>1 | y<0 | y>1 ) % out of the region
                    % do nothing
                else
                    M=zeros(2,2);
                    for ind=2:BeaconN
                        vec=norm(ptmp-pi(:,1))^(-1)*(ptmp-pi(:,1)) - norm(ptmp-pi(:,ind))^(-1)*(ptmp-pi(:,ind));
                        M=M+(vec*vec');
                    end
                    Dmat(row,col)=-log(det(M));
                end                
            end
        end
        K=Dmat-ones(Len,Len)*alpha;
        % constraints on variable domain
        picont = isInDomain(pi,ConstraintDomain);
        
        allxy=reshape(pi,BeaconN*2,1);
        c=[-allxy; allxy-ones(BeaconN*2,1)];
        ceq=[];            
end