% Beacon placement for phase localization 
% Zhen Song
% 7/8/2006

% Domain shapes are defined in JSipCont

close all;
clear all;
global p;
global pi;
global StaticP;
global wavelength;
global ConstraintDomain;

choice=6;

PiAtDiffCase=[];
wavelength=0.2;
switch(choice)
    case 1 
        tic;
        ConstraintDomain=1;

        while 1
            allrand=rand(2,4);
            indom=isInDomain(allrand, ConstraintDomain);
            if sum(indom)==-length(indom)
                disp('init. done');
                break;
            end
        end
        pi0=allrand(:,1:3);
        p0=allrand(:,4);        
       
        pi=pi0;
        p=p0;
        [pi,fval]=fseminf(@Jsip,reshape(pi0,6,1),2,@JsipCont);
        pi=reshape(pi,2,3);
        plot(pi(1,:),pi(2,:),'rd');
        title('Optimal beacon placement by min max design for TDOA localization. (with SIP)');
        axis([0 1 0 1]); axis equal;
        line([0 1 1 0 0], [0 0 1 1 0]);
        grid on;
        t1=toc

    case 2
        tic;
        ConstraintDomain=2;
       
        while 1
            allrand=rand(2,4);
            indom=isInDomain(allrand, ConstraintDomain);
            if sum(indom)==-length(indom)
                disp('init. done');
                break;
            end
        end
        pi0=allrand(:,1:3);
        p0=allrand(:,4);
        
        pi=pi0;
        p=p0;
        [pi,fval]=fseminf(@Jsip,reshape(pi0,6,1),2,@JsipCont);
        pi=reshape(pi,2,3);
        plot(pi(1,:),pi(2,:),'rd');
        title('Optimal beacon placement by min max design for TDOA localization. (with SIP)');
        axis([0 1 0 1]); axis equal;
        line([0 0.5 0.5 0 0], [0 0 1 1 0]);
        grid on;
        t2=toc
        PiAtDiffCase=[PiAtDiffCase, reshape(pi,6,1)];

    case 3
        % [0 0.5]*[0 1]+semi-circle
        global wavelength;
        global ConstraintDomain;
        ConstraintDomain = 3;

         
        
        tic;
        while 1
            allrand=rand(2,4);
            indom=isInDomain(allrand, ConstraintDomain);
            if sum(indom)==-length(indom)
                disp('init. done');
                break;
            end
        end
        pi0=allrand(:,1:3);
        p0=allrand(:,4);
        
        pi=pi0;
        p=p0;
        [pi,fval]=fseminf(@Jsip,reshape(pi0,6,1),2,@JsipCont);
        pi=reshape(pi,2,3);
        plot(pi(1,:),pi(2,:),'rd');
        title('Optimal beacon placement by min max design for TDOA localization. (with SIP)');
        axis([0 1 0 1]); axis equal;
        line([0.5 0 0 0.5], [0 0 1 1]); hold on;
        omega=linspace(-3.14/2, 3.14/2);
        cirpt=[cos(omega)*0.5+0.5; sin(omega)*0.5+0.5];
        plot(cirpt(1,:),cirpt(2,:));        
        
    case 4
        % C shape domain
        tic;
        ConstraintDomain=4;
        %% make sure the initial guess is inside the domain
        while 1
            allrand=rand(2,4);
            indom=isInDomain(allrand, ConstraintDomain);
            if sum(indom)==-length(indom)
                disp('init. done');
                break;
            end
        end
        pi0=allrand(:,1:3);
        p0=allrand(:,4);
        pi=pi0;
        p=p0;
        [pi,fval]=fseminf(@Jsip,reshape(pi0,6,1),2,@JsipCont); % constraint on Pi
        pi=reshape(pi,2,3);
        plot(pi(1,:),pi(2,:),'rd');
        title('Optimal beacon placement by min max design for TDOA localization. (with SIP)');
        axis([0 1 0 1]); axis equal;
        line([0 0.4 0.4 0.6 0.6 1 1 0 0], [0 0 0.6 0.6 0 0 1 1 0]);

        grid on;
        t4=toc        
    case 5
        %% Place beacon on the domain with a hole
        tic;
        global ConstraintDomain;
        StaticP=[];
        
        ConstraintDomain=5;
        %% make sure the initial guess is inside the domain
        while 1
            allrand=rand(2,4);
            indom=isInDomain(allrand, ConstraintDomain);
            if sum(indom)==-length(indom)
                disp('init. done');
                break;
            end
        end
        pi0=allrand(:,1:3);
        p0=allrand(:,4);
        pi=pi0;
        p=p0;
        [pi,fval]=fseminf(@Jsip,reshape(pi0,6,1),2,@JsipCont); % constraint on Pi
        pi=reshape(pi,2,3);
        plot(pi(1,:),pi(2,:),'rd');
        title('Optimal beacon placement by min max design for TDOA localization. (with SIP)');
        axis([0 1 0 1]); axis equal;
	line([0.4 0.4 0.6 0.6 0.4], [0.6 0.4 0.4 0.6 0.6]);        
        line([0 1 1 0 0], [0 0 1 1 0]);

        grid on;
        t5=toc  
    case 6
        %% progressive beacon placement
        tic;
        global ConstraintDomain;
        
        ConstraintDomain=5; % square with a hole
        BeaconN=5; % firstly place 5 beacons
        AddBeaconN=2; % then add another 2
        
        
        %% make sure the initial guess is inside the domain
        while 1
            allrand1=rand(2,BeaconN+1);
            indom=isInDomain(allrand1, ConstraintDomain); % return -1 if the beacon is inside,
            if sum(indom)==-length(indom)
                disp('init. done');
                break;
            end
        end
        pi0=allrand1(:,1:BeaconN); 
        p0=allrand1(:,end); % mobile node's position

        pi=pi0;
        p=p0;
       [piPri,fval]=fseminf(@Jsip,pi0,2,@JsipCont); % constraint on Pi
        piPri=reshape(pi,2,BeaconN);
        
%%  progressively add more beacons
        while 1
            allrand2=rand(2,AddBeaconN+1);
            indom=isInDomain(allrand2, ConstraintDomain); % return -1 if the beacon is inside,
            if sum(indom)==-length(indom)
                disp('init. done');
                break;
            end
        end
        pi0=allrand2(:,1:AddBeaconN); 
        p0=allrand2(:,end); % mobile node's position
        pi=pi0;
        p=p0;
        StaticP=piPri;
        [piPost,fval]=fseminf(@JPro,pi0,2,@JProCont); % constraint on Pi        
        piPost=reshape(pi,2,AddBeaconN);    
        
        h1=plot(piPri(1,:),piPri(2,:),'o'); 
        hold on;
        h2=plot(piPost(1,:),piPost(2,:),'rd');
        
        title('Optimal beacon placement by min max design for TDOA localization. (with SIP)');
        legend([h1, h2], 'Init.','Prog. Add');
        
        isInDomain([],5,'plot','LineWidth',2);
        axis([0 1 0 1]); axis equal;

        grid on;
        t6=toc          
end
