function [p, detM, Allp, AllPhi]=SampOpt(PosHat, SenST, sigma, eta)

SenST=SenST'; % for backward compability

SenN = size(SenST,1);
detM=[];
p=ones(SenN,1)/SenN;
dim=2;
atomfim=zeros(dim,dim,SenN);

for cnt=1:SenN
    atomfim(:,:,cnt)=SenST(cnt,:)'*SenST(cnt,:)*sigma^(-2);
end
phi=zeros(SenN,1);
% eta=1e-5;
itnum=0;
AllPhi=[];
Allp=[];
while 1
    M=zeros(dim,dim);
    for cnt=1:SenN
        M=M+atomfim(:,:,cnt)*p(cnt);
    end
    detM=[detM det(M)];
    phi=diag(SenST*inv(M)*SenST'*sigma^(-2));    
    
    AllPhi=[AllPhi, phi];    
    Allp=[Allp, p];    
    
    tmp=max(phi)/dim ;
    if tmp< 1+eta;
        break;
    end
    p=p.*phi/dim;
    itnum=itnum+1;
end

return;
