%  Sensor Selection Simulation
%
%
%  Zhen Song
%  zhen.song@siemens.com

clear all;
close all;
Mode = 2
% Mode 
% 1: Plot light field.
% 2: Select sensors using hCOSS and eCOSS methods.
% In Mode 2, assign ConfigSenPos as 1 or 2 in order to place sensors at
% different locations.
  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Plot light field
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if Mode == 1
    close all;
    SaveStr=[];    
    NSample = 250; % total sampling number of the whole network
    sigmaScalar = 0.5;
    %    sigmaScalar = 0.25;
    
    eta=1e-2;        
    ThresholdSelection = 0.1; %0.002;
    % consts
    in2cm = 2.54;    
    
    LampPos=[14; 7]   
    %    LampPos=[25; 35];
    
    global  C LampHeight 
    %     global SenPos C SenVal LampHeight     
    
    % settings
    SampDensity = 10; % samples^2 per cm^2
    %     SampDensity = 0.01; % samples^2 per cm^2    
    GridSizeIn = 2;
    %     GridSizeIn = 16.7;
    
    %     GridNumX = 5; GridNumY=3;
    GridNumX = 10; GridNumY=6;    
    SensorNum=GridNumX*GridNumY;
    
    C=(8*2.54)^2*8000;    % Thus, the max reading is 2000
    LampHeight=8*in2cm;
    %     ScaleFactorZ = LampHeight^2 * 2;   
    % generate net 
    xpos=[0:GridNumX-1]*GridSizeIn*in2cm;
    ypos=[0:GridNumY-1]*GridSizeIn*in2cm;
    TheDomain=[[-1 GridNumX -1  GridNumY]*GridSizeIn*in2cm, [0 C/LampHeight^2 *1.1]];
    %    SenPos=[repmat(xpos,1,GridNumY); ... 
    %            reshape(ones(GridNumX,1)*ypos,1,GridNumX*GridNumY)];
    
    SenPos=rand(2,60)*40;
    
    figure(1);    
    % subplot(2,1,1);
    h=plot(SenPos(1,:), SenPos(2,:),'*'); 
    hold on;    
    axis equal; axis (TheDomain);    
    h2=plot(LampPos(1), LampPos(2), 'ko');
    legend([h,h2],'Sensor','Target');
    
    % light field
    x=linspace(TheDomain(1), TheDomain(2), SampDensity*(TheDomain(2)-TheDomain(1)))';
    y=linspace(TheDomain(3), TheDomain(4), SampDensity*(TheDomain(4)-TheDomain(3)))';
    LightMesh= C./( LampHeight.^2 + (ones(length(y),1)*x'-LampPos(1)*ones(length(y),length(x))).^2 + ...
        (y*ones(1, length(x))-LampPos(2)*ones(length(y),length(x))).^2 );
    contour(x',y,LightMesh);
    mesh(x',y,LightMesh);
    xlabel('x (cm)'); ylabel('y (cm)'); zlabel('z (Brightness)');
    title('Light field');
    set(gcf,'Position', [155 272 798 649]);
    alpha(0.5);
    tmax=max(max(LightMesh));
    campos([-20 -80 tmax*2]);    
    title([ 'Light field based on energy model.' ...
            '(brightness=' num2str(C) '/(' num2str(LampHeight) '^2+r^2) )']); 
    if length(SaveStr)>1
        print('-deps2c', [SaveStr, 'LightField']);
    end
end

if Mode==2
    close all;
    in2cm = 2.54;    % convert inch to cm.
    %ConfigSenPos=1 % 60 sensors at randon
    ConfigSenPos=2 % 15 sensors in grid
    
    SaveStr=[];    
    NSample = 50;
    sigmaScalar = 0.1; % noise level
    eta=1e-2;    
    ThresholdSelection = 0.1; 
    ThresholdSelection2 = 0;
    
    switch ConfigSenPos
        case 1 % 60 sensors at randon
            LampPos=[14; 7]           
            SensorNum = 60;
            BoradSize = 40;
            SenPos=rand(2, SensorNum )*BoradSize; 
        case 2 % 15 sensors in grid
            LampPos=[14; 7]               
            GridNumX = 5; GridNumY=3;    
            GridSizeIn = 17;            
            %             GridSizeIn = 16.7;             
            SensorNum=GridNumX*GridNumY;
            xpos=[0:GridNumX-1]*GridSizeIn*in2cm;
            ypos=[0:GridNumY-1]*GridSizeIn*in2cm;            
            SenPos=[repmat(xpos,1,GridNumY); ... 
                    reshape(ones(GridNumX,1)*ypos,1,GridNumX*GridNumY)];
    end
    
   
    
    global  C LampHeight 
    %     global SenPos C SenVal LampHeight     
    
    C=(8*2.54)^2*8000;    % Thus, the max reading is 2000. This number is measured from hardware experiments.
    LampHeight=8*in2cm;
    if ConfigSenPos == 2
        TheDomain=[[-1 GridNumX -1  GridNumY]*GridSizeIn*in2cm, [0 C/LampHeight^2 *1.1]];
    end
    
    figure(1);
    set(gcf, 'Position', [17 319 1236 606]);
    hSen=plot(SenPos(1,:),SenPos(2,:),'*','LineWidth', 2, 'MarkerSize',15);
    hold on;    
    %/////////////////////////// Sensor Reading   /////////////////////////
    
    SenVal= SensorModel(SenPos, LampPos, 'energy');
    mm=max(max(SenVal));
    sigma=mm*sigmaScalar;    
    Noise = mean(randn(SensorNum,round(NSample/SensorNum)) * sigma, 2);    
    SenVal=SenVal+Noise;
    
    %/////////////////////////// LS Fit 1   /////////////////////////
    Pos0=mean(SenPos,2);
    LSDat=struct('SenPos',SenPos,'SenVal',SenVal,'C',C,'LampHeight',LampHeight);
    Optset=optimset('fmincon');

    if ConfigSenPos == 1
        [Pos1 FVAL1,EXITFLAG1,OUTPUT1,LAMBDA1,GRAD1,HESSIAN1] =fmincon(@EnergyErr, Pos0, [],[],[],[], ...
            [0;0], [BoradSize; BoradSize], [], Optset, LSDat);
    end 
    if ConfigSenPos == 2
        [Pos1 FVAL1,EXITFLAG1,OUTPUT1,LAMBDA1,GRAD1,HESSIAN1] =fmincon(@EnergyErr, Pos0, [],[],[],[], ...
            [0;0], [GridNumX; GridNumY]*GridSizeIn*in2cm, [], Optset, LSDat);
    end
    
    Pos1
    %// get sensitivity
    SenST = SensitivityComp(SenPos, Pos1, 'energy');
    
    ErrM1=zeros(2,2);
    for cnt=1:SensorNum;
        ErrM1=ErrM1+sigma^(-2)*SenST(:,cnt)*SenST(:,cnt)' * round(NSample/SensorNum);
    end
    h1ball=plotEllipse(Pos1,inv(ErrM1),':k');
    h1pos=plot(Pos1(1),Pos1(2),'+k');
    set(h1ball,'LineWidth',3);    
    set(h1pos,'LineWidth',3,'MarkerSize',10);
    
    disp([' Est error = ' num2str(norm(Pos1-LampPos))]);
    %/////////////////////////// Sensor Selection /////////////////////////
    %% mult. method    
    
    tic; 
    
    [p detM Allp AllPhi]=SampOpt(Pos1, SenST, sigma, eta);
    pBak=p;
    cutoff=1/20/5;
    
    %% Heuristic selection
    t=sort(p);
    HeuP = zeros(size(p));
    HeuPRound=round(p*NSample);    
    HeuSenInd = find(p > ThresholdSelection );
    HeuP(HeuSenInd) = p(HeuSenInd);
    HeuSelSenPos=SenPos(:,HeuSenInd);
    
    Mstack=[];
    for cnt=1:SensorNum;
        Mstack=[Mstack p(cnt)*[SenST(1,cnt)^2; SenST(2,cnt)^2; SenST(1,cnt)*SenST(2,cnt)] ];
    end
    %% Convex elimination
    p0Cvx=zeros(size(p));
    p0ind = find(p >= ThresholdSelection2);
    p0Cvx(p0ind)=p(p0ind);
    CvxP=fCvxElim(Mstack, p0Cvx, 1e-3);
    %% sample again
    alltime=toc
    

    CvxPRound=round(CvxP*NSample);    
    [HeuSenVal, HeuSelSenPos] = SenSampleAgain(SenPos, LampPos, NSample, sigma, HeuPRound , 'energy');
    [CvxSenVal, CvxSelSenPos] = SenSampleAgain(SenPos, LampPos, NSample, sigma, CvxPRound , 'energy');
    
    CvxSenInd = find(CvxPRound > 0);    
    
    %/////////////////////////// LS Fit 2  /////////////////////////    
    %  new estimation on event position
    %     LSDat2=struct('InitPos',Pos0,'SenPos',SelSenPos,'SenVal',SelSenVal);
    if ConfigSenPos == 1
        HeuLSDat2=struct('SenPos',HeuSelSenPos,'SenVal', HeuSenVal,'C',C,'LampHeight',LampHeight);    
        [HeuPos2 FVAL2,EXITFLAG2,OUTPUT2,LAMBDA2,GRAD2,HESSIAN2] =fmincon(@EnergyErr, LampPos, [],[],[],[], ...
        [0;0], [BoradSize; BoradSize], [], Optset, HeuLSDat2);
    
        CvxLSDat2=struct('SenPos',CvxSelSenPos,'SenVal', CvxSenVal,'C',C,'LampHeight',LampHeight);    
        [CvxPos2 FVAL2,EXITFLAG2,OUTPUT2,LAMBDA2,GRAD2,HESSIAN2] =fmincon(@EnergyErr, LampPos, [],[],[],[], ...
            [0;0], [BoradSize; BoradSize], [], Optset, CvxLSDat2);    
        
    end
    
    if ConfigSenPos == 2
        HeuLSDat2=struct('SenPos',HeuSelSenPos,'SenVal', HeuSenVal,'C',C,'LampHeight',LampHeight);    
        [HeuPos2 FVAL2,EXITFLAG2,OUTPUT2,LAMBDA2,GRAD2,HESSIAN2] =fmincon(@EnergyErr, LampPos, [],[],[],[], ...
        [0;0], [GridNumX; GridNumY]*GridSizeIn*in2cm, [], Optset, HeuLSDat2);
    
        CvxLSDat2=struct('SenPos',CvxSelSenPos,'SenVal', CvxSenVal,'C',C,'LampHeight',LampHeight);    
        [CvxPos2 FVAL2,EXITFLAG2,OUTPUT2,LAMBDA2,GRAD2,HESSIAN2] =fmincon(@EnergyErr, LampPos, [],[],[],[], ...
            [0;0], [GridNumX; GridNumY]*GridSizeIn*in2cm, [], Optset, CvxLSDat2);    
    end
    % get sensitivity
    HeuSenST2 = SensitivityComp(SenPos, HeuPos2, 'energy');
    CvxSenST2 = SensitivityComp(SenPos, CvxPos2, 'energy');    
    HeuErrM2=ErrorFIM(HeuSenST2, sigma, NSample, HeuP);    
    CvxErrM2=ErrorFIM(CvxSenST2, sigma, NSample, CvxP);        

    h2HeuBall=plotEllipse(HeuPos2,inv(HeuErrM2),'g');
    set(h2HeuBall,'LineWidth',3);
    h2HeuPos=plot(HeuPos2(1),HeuPos2(2),'xg');
    set(h2HeuPos,'LineWidth',2,'MarkerSize',10);
    h2HeuSelSen=plot(SenPos(1,HeuSenInd),SenPos(2,HeuSenInd),'gs');
    set(h2HeuSelSen,'LineWidth',2,'MarkerSize',15);
    
    h2CvxBall=plotEllipse(CvxPos2,inv(CvxErrM2),'m-.');
    set(h2CvxBall,'LineWidth',3);
    h2CvxPos=plot(CvxPos2(1), CvxPos2(2),'m^');
    set(h2CvxPos,'LineWidth',2,'MarkerSize',10);   
    h2CvxSelSen=plot(SenPos(1,CvxSenInd),SenPos(2,CvxSenInd),'mv');
    set(h2CvxSelSen,'LineWidth',2,'MarkerSize',15);
    
    hlamp = plot(LampPos(1),LampPos(2),'ko', 'LineWidth', 2, 'MarkerSize',9);    
    legend([h1ball, ...
            h2HeuBall, h2CvxBall, h1pos,h2HeuPos, h2CvxPos hlamp,h2HeuSelSen, h2CvxSelSen],...
        'A pri. conf. ellip.','A post. conf. ellip. (heuristic)', 'A post. conf. ellip. (elimination)', ...
        'A pri. est.','A post. est. (heuristic)','A post. est. (elimination)', 'Target', ...
        'Selected sensor (heuristic)' , 'Selected sensor (elimination)');
    axis equal; 
    if ConfigSenPos == 2     
        axis (TheDomain(1:4));        
    end
    
    
    Err1=norm(Pos1-LampPos);
    HeuErr2=norm(HeuPos2-LampPos);
    CvxErr2=norm(CvxPos2-LampPos);    
    Ratio21Heu=HeuErr2/Err1;
    Ratio21Cvx=CvxErr2/Err1;    
    DetInvM1=det(inv(ErrM1));
    HeuDetInvM2=det(inv(HeuErrM2));
    HeuDetInvM21=HeuDetInvM2/DetInvM1;
    CvxDetInvM2=det(inv(CvxErrM2));
    CvxDetInvM21=CvxDetInvM2/DetInvM1;
    
    SNRmax=20*log10(1/sigmaScalar);
    SNRamp=-20*log10(mean(Noise.^2)/mean(SenVal.^2));
    SNRpow=-10*log10(mean(Noise.^2)/mean(SenVal.^2));
    disp(['Err1=' num2str(Err1)]);
    disp(['HeuErr2=' num2str(HeuErr2)]);    
    disp(['CvxErr2=' num2str(CvxErr2)]);        
    disp(['HeuErr2/Err1=' num2str(Ratio21Heu)]);        
    disp(['CvxErr2/Err1=' num2str(Ratio21Cvx)]);            
    disp(['DetInvM1=' num2str(DetInvM1)]);
    disp(['HeuDetInvM2=' num2str(HeuDetInvM2)]);        
    disp(['CvxDetInvM2=' num2str(CvxDetInvM2)]);            
    disp(['HeuDetInvM2/DetInvM1=' num2str(HeuDetInvM21)]);        
    disp(['CvxDetInvM2/DetInvM1=' num2str(CvxDetInvM21)]);            
    disp(['SNR max amp =' num2str(SNRmax)]);            
    disp(['SNR amp =' num2str(SNRamp)]);                
    disp(['SNR pow =' num2str(SNRpow)]); % more sample point
    
    figure(2)
    h1=stem(HeuPRound,'g');
    hold on;
    h2=stem(CvxPRound,'-.');
    title('Comparisons on the unite time sample number of selected sensors.');
    legend([h1(1), h2(1)], 'hCOSS', 'eCOSS',2);
    xlabel('Sensor ID'); ylabel('Normalized sampling rate');
    
    figure(3)
    plot(-log(detM),'LineWidth',3);
    grid on;
    disp(['iteration num=' num2str(size(detM,2))]);    
end




