// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  decrypt_file.cpp
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Stephan Riedel, stephan-riedel@gmx.de
// Date:      07.08.2008
// *****************************************************************

#include <tools/AES.h>

using namespace std;

int main (int argc, char* argv[]) {

	string src, dest;

	if(argc != 3) {
		printf("Usage: %s <input_file> <output_file>\n", argv[0]);
		exit (0);
	}
	else {
		src = argv[1];
		dest = argv[2];
	}

	cout << "Decrypting " << src << " to " << dest << endl;
	AES Encryption;
	Encryption.importDataFromFile(src);
	Encryption.decrypt();
	Encryption.writeDataToFile(dest);

	return 0;
}

