// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  main.c
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      04.10.2008
// *****************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>
#include "vsopenrisc.h"

int main() {

	int fd;
	fd = open("/dev/gpio", O_RDWR);
	if (fd < 0) {
		perror("could not open /dev/gpio");
		exit(1);
	}

	struct gpio_struct cmd_val;
	cmd_val.mask = 0xff;
	cmd_val.value = 0x0f;
	if(ioctl(fd, GPIO_CMD_SET_CTRL, &cmd_val) == -1) {
		perror("ioctl: GPIO_CMD_SET_CTRL failed");
		exit(1);
	}
	unsigned long cmd_ret_val;
	if(ioctl(fd, GPIO_CMD_GET_CTRL, &cmd_ret_val) == -1) {
		perror("ioctl: GPIO_CMD_GET_CTRL failed");
		exit(1);
	}
	printf("Value: 0x%02X\n\n", cmd_ret_val);

	struct gpio_struct val;
	val.mask = 0xc3;
	val.value = 0xff;
	if(ioctl(fd, GPIO_CMD_SET, &val) == -1){
		perror("ioctl: GPIO_CMD_SET failed");
		exit(1);
	}
	unsigned long ret_val;
	if(ioctl(fd, GPIO_CMD_GET, &ret_val) == -1) {
		perror("ioctl: GPIO_CMD_GET failed");
		exit(1);
	}
	printf("Value: 0x%02X\n\n", ret_val);

}


