// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  main.c
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      25.08.2008
// *****************************************************************

#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <linux/watchdog.h>

#define KEEPALIVE 1

int main(int argc, char **argv)
{
	int i;
	int sleep_time = 0;
	int timeout = 0;
	int flags = 0;
	
	if(argc != 3)
	{
		printf("Usage: %s <sleep_time> <timeout> (in seconds)\n", argv[0]);
		return 0;
	}
	else
	{
		sleep_time = atoi(argv[1]);
		timeout = atoi(argv[2]);
	}

	// open watchdog device
	int fd = open("/dev/watchdog", O_RDWR);
	if(fd < 0) perror("Could not open /dev/watchdog");

	// set watchdog timeout
	if(ioctl(fd, WDIOC_SETTIMEOUT, &timeout) < 0)
		perror("Error setting timeout");

	for (i=0; i<5;i++) {
		printf("Sleeping for %d seconds\n",sleep_time);
		sleep(sleep_time);
		if (KEEPALIVE) {
			printf("Sending keepalive signal\n");
			if(ioctl(fd, WDIOC_KEEPALIVE, NULL) < 0)
				perror("Error setting timeout");
		}
	}

	// stop watchdog timer
	flags |= WDIOS_DISABLECARD;
	if(ioctl(fd, WDIOC_SETOPTIONS, &flags) < 0)
		perror("Error stopping watchdog");
		
	close(fd);
	return 0;
}
