// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  formhandler.cpp
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      07.11.2008
// *****************************************************************

#include <iostream>
#include "tools/ParamFile.h"

/* purpose of this app:
	1. read data file, which is defined in "config.dat"
	2. check if tempmes process is running
	3. fill html skeleton with values from data file,
	and write the result to std::out
*/

using namespace std;

void send_msg(string s) {
	
	cout << "Content-Type: text/html\n\n";	// need to have two newlines!!
	cout << "<html>\n";
	cout << "<head>\n";
	cout << "<meta http-equiv=""refresh"" content=""1; URL=/cgi-bin/formhandler"">";
	cout << "<title>Message</title>\n";
	cout << "</head>\n";
	cout << "<body>\n";
	cout << "<h3>" << s << "</h3>\n";
	cout << "</body>\n";
	cout << "</html>\n";
}

int main()
{

	ParamFile my_config("config.dat");
	if (my_config.read() < 0) {
		send_msg("Could not open config.dat");
		return 0;
	}

	// 1. read data file
	ParamFile to_webserver(my_config.getValue("FILENAME_to_webserver"));
	to_webserver.read();
	to_webserver.makeEntry("CGINAME_STATUS","connected");
	
	// 2. is process tempmes running?
	ifstream f;
	f.open(my_config.getValue("PROCESS_FILE").c_str(), ios::in);
	if ( !f.is_open() ) {
		f.close();
		to_webserver.clear();
		to_webserver.makeEntry("CGINAME_STATUS","not_connected");
		to_webserver.makeEntry("CGINAME_TEMPCOLOR", "FFFFFF");
	}
	string pid;
	getline(f, pid);
	f.close();
	
	f.open(("/proc/" + pid + "/status").c_str(), ios::in);
	if ( !f.is_open() ) {
		f.close();
		to_webserver.clear();
		to_webserver.makeEntry("CGINAME_STATUS","not_connected");
		to_webserver.makeEntry("CGINAME_TEMPCOLOR", "FFFFFF");
	}
	f.close();
	to_webserver.write();
	
	size_t pos_name = 0;
	size_t pos_value = 0;
	
	// 3. step through html skeleton and do search/replace with data file values
	f.open(my_config.getValue("HTMLFILE_IN").c_str(), ios::in);
	if ( !f.is_open() ) {
		send_msg("Could not open file " + my_config.getValue("HTMLFILE_IN"));
		return 0;
	}
		
	string line;
	size_t pos_start, pos_end;

	while (!f.eof()) { // step through lines
		getline(f, line);
		
		pos_start = line.find_first_of("$$",0);
		pos_end = line.find_first_of("$$",pos_start+2);
		if ( pos_end != string::npos) {
			string name_full = line.substr(pos_start, pos_end + 2 - pos_start);
			string name = name_full.substr(2, name_full.size() - 4);
			if ( to_webserver.getValue(name) != "" )
				line.replace(pos_start,name_full.size(),to_webserver.getValue(name));
			else	
				line.replace(pos_start,name_full.size(),"");
		}	
		cout << line << endl;
	}
	f.close();
	
	return 0;
}


