// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  tempmeasure.cpp
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      07.11.2008
// *****************************************************************


//#define USE_IIC

#include <cstdio>
#include <iostream>
#include "tools/ParamFile.h"

#ifdef USE_IIC
#include "iic/Bus.h"
#include "iic/Base.h"
#include "iic/TempSensor.h"
#endif

using namespace std;

int main()
{

	double act_temp = 0.0;
	double min_temp = 20.0;
	double max_temp = 30.0;
	double temp_dir = 0.0;

#ifdef USE_IIC
	IICBus bus("/dev/i2c-0", 0); // Interface type native iic
	IICTempSensor sensor(bus,0x4f, "Temperatursensor",0,1); // 9 Bit, TOUT active high
	bus.init();

	sensor.setThermostat((int)min_temp*10, (int)max_temp*10); // 20°C and 30°C
	sensor.startConvert();
#endif


	ParamFile my_config("cgi-bin/config.dat");
	if (my_config.read() < 0) {
		cout << "Could not open cgi-bin/config.dat" << endl;
		return 0;
	}

	ofstream f;
	f.open(my_config.getValue("PROCESS_FILE").c_str(), ios::trunc);
	if ( !f.is_open() ) {
		cout << "Could not open file " << my_config.getValue("PROCESS_FILE") << endl;
		return 0;
	}
	f << (int) getpid() << endl;
	f.close();
	cout << "Saving process id " << getpid() << " in " << my_config.getValue("PROCESS_FILE") << endl;

	ParamFile to_webserver(my_config.getValue("FILENAME_to_webserver"));

	int counter = 0;
	char temp_str[20];

	time_t t;
	tm *nun;

	to_webserver.clear();

	sprintf(temp_str, "%2.1f", min_temp);
	to_webserver.makeEntry("CGINAME_MINTEMP", temp_str);
	sprintf(temp_str, "%2.1f", max_temp);
	to_webserver.makeEntry("CGINAME_MAXTEMP", temp_str);

	while(1) {

#ifdef USE_IIC
		act_temp = sensor.readTemp() / 10.0;
#else
		act_temp += temp_dir;
		if (act_temp >= max_temp + 5) temp_dir = -1.0;
		if (act_temp < min_temp - 5) temp_dir = +1.0;
#endif
		t = time(0);
		nun = localtime(&t);

		sprintf(temp_str, "%02d:%02d:%02d", nun->tm_hour, nun->tm_min, nun->tm_sec);
		to_webserver.makeEntry("CGINAME_TIME", temp_str);
		sprintf(temp_str, "%d", counter);
		to_webserver.makeEntry("CGINAME_COUNTER", temp_str);
		sprintf(temp_str, "%2.1f", act_temp);
		to_webserver.makeEntry("CGINAME_ACTTEMP", temp_str);

		if ( act_temp < min_temp) {
			to_webserver.makeEntry("CGINAME_TEMPCOLOR", "0000FF");
			to_webserver.makeEntry("CGINAME_TEMPSTATUS", "LOW");
		}
		else if ( act_temp < max_temp) {
			to_webserver.makeEntry("CGINAME_TEMPCOLOR", "00FF00");
			to_webserver.makeEntry("CGINAME_TEMPSTATUS", "NORMAL");
		}
		else if ( act_temp >= max_temp) {
			to_webserver.makeEntry("CGINAME_TEMPCOLOR", "FF0000");
			to_webserver.makeEntry("CGINAME_TEMPSTATUS", "HiGH");
		}
		to_webserver.write();
		cout << "Data written to " << my_config.getValue("FILENAME_to_webserver") << endl;
		counter++;
		sleep(1);
	}

	return 0;
}


