// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  formhandler.cpp
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      07.11.2008
// *****************************************************************


#include <iostream>
#include "tools/ParamFile.h"

#define MAX_DATA_TIME 3

/* purpose of this app:
	1. read data files TO and FROM, both defined in "config.dat"
	2. check if tempmes process is running
	3. parse incoming query string
	4. process query entires and deliver data (from),
	or answer data request (to)
*/

using namespace std;

void send_msg(string s) {
	cout << "Content-Type: text/html\n\n";
	cout << "CGINAME_ALERT=" << s << endl;
}

int main(int argc, char *argv[], char *env[])
{
	string in = "";

	ParamFile my_config("config.dat");
	if (my_config.read() < 0) {
		send_msg("Could not open config.dat");
		return 0;
	}

	// 1. read both data file TO and data file FROM
	ParamFile from_webserver(my_config.getValue("FILENAME_from_webserver"));
	from_webserver.read();
	ParamFile to_webserver(my_config.getValue("FILENAME_to_webserver"));
	to_webserver.read();
	to_webserver.makeEntry("CGINAME_STATUS","connected");

	// 2. is the process running?
	ifstream f;
	f.open(my_config.getValue("PROCESS_FILE").c_str(), ios::in);
	if ( !f.is_open() ) {
		f.close();
		to_webserver.clear();
		to_webserver.makeEntry("CGINAME_STATUS","not_connected");
		to_webserver.makeEntry("CGINAME_TEMPCOLOR", "FFFFFF");
	}
	string pid;
	getline(f, pid);
	f.close();
	
	f.open(("/proc/" + pid + "/status").c_str(), ios::in);
	if ( !f.is_open() ) {
		f.close();
		to_webserver.clear();
		to_webserver.makeEntry("CGINAME_STATUS","not_connected");
		to_webserver.makeEntry("CGINAME_TEMPCOLOR", "FFFFFF");
	}
	f.close();
	to_webserver.write();
	
	cin >> in;
	//send_msg(in);

	size_t pos_name = 0;
	size_t pos_value = 0;
	
	// 3. read query string, parse into query_string map
	map <string, string> query_string;
	map<string,string>::iterator qs_iter; 

	bool done = false;
	while (!done) {

		pos_value = min(in.find_first_of("=",pos_name), in.size());
		string name = in.substr(pos_name, pos_value - pos_name);
		if ( pos_value != in.size() ) pos_value++;
		else break;

		pos_name = min(in.find_first_of("&",pos_value), in.size());

		string value = in.substr(pos_value, pos_name - pos_value);
		if ( pos_name < in.size() ) pos_name++;
		else done = true;

		query_string.insert( make_pair(name,value) );
	}

	qs_iter = query_string.begin();
	// end here if there is no pair
	if (query_string.size() == 0) {
		cout << "Content-Type: text/html\n\n";
		cout << "CGINAME_DIR=from&" << endl;
		return 0;
	}

	// 4. datadeliver (from), or data request (to)?
	if ((qs_iter->first == "CGINAME_DIR") && (qs_iter->second == "from")) {	
	  	for( qs_iter = query_string.begin(); qs_iter != query_string.end(); qs_iter++ ) {
	    	from_webserver.makeEntry(qs_iter->first, qs_iter->second);
	  	}
		from_webserver.write();
		cout << "Content-Type: text/html\n\n";
		cout << "CGINAME_DIR=from&" << endl;
	}
	
	else {
		
		cout << "Content-Type: text/html\n\n";
		cout << "CGINAME_DIR=to&";
		
			map<string,string>::iterator iter_begin = to_webserver.getBegin(); 
			map<string,string>::iterator iter_end = to_webserver.getEnd(); 
		for( qs_iter = iter_begin; qs_iter != iter_end; qs_iter++ ) {
			cout << qs_iter->first << "=" << qs_iter->second << "&";
  		}
		cout << endl;
	}
	return 0;
}


