// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  main.cpp
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Stephan Riedel, stephan-riedel@gmx.de
// Date:      27.04.2008
// *****************************************************************

#include <iostream>
#include <sys/ioctl.h>
#include <iic/Bus.h>
#include <iic/ChipCard.h>

typedef struct {
       char name[20];
       char last_name[20];
       unsigned int personal_number;
       int age;
} EntranceCard;

int main () {

	IICBus Bus("/dev/i2c-0", 0);											// native i2c
	//IICBus Bus("/dev/iowarrior",1,"00001FEC");							// i2c via IOWarrior

	Bus.autodetect();

	EntranceCard Badge;

	// chipcard object: IICBUS, address i2c bus, name, pointer to data, size of data
	IICChipCard Chipcard(Bus,0x50,"Chipcard");
	
	while ( !Chipcard.isAvailable() ) {									// check if chipcard is available
		std::cout << "Error: Please insert chipcard!\n\n";
		sleep(5);	
	}

	Chipcard.printSCHeader();														// read header

	if (Chipcard.readSCData((char*) &Badge, sizeof(Badge)) == -1) return -1;			// read data from EEPROM

	std::cout << "Name:             " << Badge.name << " " << Badge.last_name << std::endl;
	std::cout << "Personal Number:  " << Badge.personal_number << std::endl;
	std::cout << "Age:              " << Badge.age << std::endl;

	std::cout << "Card Data:" << std::endl;
	char* buf = (char*)&Badge;
	for (int i=0; i < sizeof(Badge); i++) {
		std::cout << buf[i] << " ";
		if ((i+1) % 10 == 0) std::cout << std::endl;
	}
	std::cout << std::endl;
	return 0;
}

