// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  main.cpp
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Stephan Riedel, stephan-riedel@gmx.de
// Date:      27.04.2008
// *****************************************************************

#include <iostream>
#include <sys/ioctl.h>
#include <iic/Bus.h>
#include <iic/ChipCard.h>
#include <string>

//#define FORMAT_HEADER

typedef struct {
       char name[20];
       char last_name[20];
       unsigned int personal_number;
       int age;
} EntranceCard;

int main () {

	IICBus Bus("/dev/i2c-0", 0);											// native i2c
	//IICBus Bus("/dev/iowarrior",1,"00001FEC");							// i2c via IOWarrior

	Bus.autodetect();

	EntranceCard Badge;

	// chipcard object: IICBUS, address i2c bus, name, pointer to data, size of data
	IICChipCard Chipcard(Bus,0x50,"Chipcard");

	while (Chipcard.isAvailable() < 0) {									// check if chipcard is available
		std::cout << "Error: Please insert chipcard!\n\n";
		sleep(5);	
	}

#ifdef FORMAT_HEADER
	Chipcard.formatSCHeader("314159265","Entrance Card");				// format header: ID, description, no encryption
#endif

	// set data for entrance card
	strcpy(Badge.name, "Hannes");
	strcpy(Badge.last_name, "Handsome");
	Badge.personal_number = 37495087;
	Badge.age = 25;

	// write data to EEPROM
	Chipcard.writeSCData((char*)&Badge, sizeof(Badge));

	return 0;
}

