// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  main.cpp
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Stephan Riedel, stephan-riedel@gmx.de
// Date:      25.06.2008
// *****************************************************************

#include <iostream>
#include <sys/ioctl.h>
#include <iic/Bus.h>
#include <iic/ChipCard.h>
#include <tools/AES.h>

typedef struct {
       char name[20];
       char last_name[20];
       unsigned int personal_number;
       int age;
} EntranceCard;

int main () {

	IICBus Bus("/dev/i2c-0", 0);										// native i2c
	//IICBus Bus("/dev/iowarrior",1,"00001FEC");						// i2c via IOWarrior

	Bus.autodetect();

	EntranceCard Badge;
	AES Encryption;

	char* ch_buffer = (char*)malloc(Encryption.decrToEncrSize(sizeof(Badge)));
	
	IICChipCard Chipcard(Bus,0x50,"Chipcard");

	while (Chipcard.isAvailable() < 0) {								// check if chipcard is available
		std::cout << "Error: Please insert chipcard!\n\n";
		sleep(5);
	}

	Chipcard.printSCHeader();												// read header
	Chipcard.readSCData(ch_buffer, Encryption.decrToEncrSize(sizeof(Badge)));													// read data from EEPROM

	Encryption.importData(ch_buffer, Encryption.decrToEncrSize(sizeof(Badge)));	// if you know that it is decrypted, this size is enough to determine korrekt size!
	Encryption.decrypt();													// decrypt data
	memcpy(&Badge, Encryption.getData(), sizeof(Badge));

	std::cout << "Name:             " << Badge.name << " " << Badge.last_name << std::endl;
	std::cout << "Personal Number:  " << Badge.personal_number << std::endl;
	std::cout << "Age:              " << Badge.age << std::endl;

	std::cout << "Card Data:" << std::endl;
	for (int i=0; i < Encryption.decrToEncrSize(sizeof(Badge)); i++) {
		std::cout << ch_buffer[i] << " ";
		if ((i+1) % 10 == 0) std::cout << std::endl;
	}	
	std::cout << std::endl;
	free(ch_buffer);
	return 0;
}

