// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  main.cpp
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Stephan Riedel, stephan-riedel@gmx.de
// Date:      25.06.2008
// *****************************************************************

#include <iostream>
#include <sys/ioctl.h>
#include <iic/Bus.h>
#include <iic/ChipCard.h>
#include <tools/AES.h>

//#define FORMAT_HEADER

typedef struct {
       char name[20];
       char last_name[20];
       unsigned int personal_number;
       int age;
} EntranceCard;

int main () {

	IICBus Bus("/dev/i2c-0", 0);  // native i2c
	//IICBus Bus("/dev/iowarrior",1,"00001FEC");  // i2c via IOWarrior

	Bus.autodetect();

	EntranceCard Badge;
	// fill up struct
	strcpy(Badge.name, "Hannes");
	strcpy(Badge.last_name, "Handsome:uiiiii");
	Badge.personal_number = 37495087;
	Badge.age = 25;

	AES Encryption;
	Encryption.importData((char*)&Badge, sizeof(Badge));
	Encryption.encrypt();

	IICChipCard Chipcard(Bus,0x50,"Chipcard");


	// check if chipcard is available
	while (Chipcard.isAvailable() < 0) {
		std::cout << "Error: Please insert chipcard!\n\n";
		sleep(5);	
	}

	// format header: ID, description
	#ifdef FORMAT_HEADER
		Chipcard.formatSCHeader("314159265","Entrance Card");
	#endif

	// write data to EEPROM
	Chipcard.writeSCData(Encryption.getData(), Encryption.getEncryptedSize());

	return 0;
}

