// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  main.cpp
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Stephan Riedel, stephan-riedel@gmx.de
// Date:      25.07.2008
// *****************************************************************

#include "iic/Bus.h"
#include "iic/Base.h"
#include "iic/ADConverter.h"

#define VREF 4.8


int main() {

	//IICBus bus("/dev/i2c-0",0); // Interface type native iic
	IICBus bus("/dev/iowarrior",1,"00001FEC"); // Interface type iowarrior iic
	IICADConverter converter(bus, 0x48, "D/A Converter", SINGLE_ENDED_INPUT);
	bus.init();

	converter.setScoreTable((int)(2.75/VREF*255),17,0);
	converter.setScoreTable((int)(2.5/VREF*255),21,0);	
	converter.setScoreTable((int)(2.25/VREF*255),25,0);
	converter.setScoreTable((int)(2.0/VREF*255),30,0);
	converter.setScoreTable((int)(1.75/VREF*255),35,0);
	converter.setScoreTable((int)(1.5/VREF*255),41,0);
	converter.setScoreTable((int)(1.25/VREF*255),50,0);
	converter.setScoreTable((int)(1.0/VREF*255),64,0);
	converter.setScoreTable((int)(0.75/VREF*255),85,0);
	converter.setScoreTable((int)(0.4/VREF*255),150,0);

	int value;

	while(1){
		value = converter.readChannel(0,0,-1);
		printf("Channel value: %d\n",value);
		converter.setOutput(value);
		printf("Setting DA value to %d\n",value);

		printf("Distance to sensor is %d cms\n", converter.readChannel(0,1,0));
		usleep(1000000);
	}

	return 0;
}

