// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  main.c
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      01.09.2008
// *****************************************************************

#include <stdio.h>
#include "tools/iowarrior_i2c.h"

int main (int argc, char **argv) {

	char serial[9]="00001FEC";
	char basename[20]="/dev/iowarrior";
	char buf[2];
	int i;
	char address = 0x4f;

	iow_print_warriors(basename);

	int fd = iow_find_special_descriptor(serial, basename);
	if ( fd  < 0) {
		printf("Device with serial 0x%s could not be found\n", serial);
		exit(0);
	}

	int report_size = iow_i2c_init(fd);		
	
	// start conversion
	buf[0] = 0x51;	// command: start conversion
	if (iow_i2c_write(address, buf, 1, report_size, fd) !=1)
		printf("iic write error\n");	
		
	sleep(1); // wait for conversion to complete
				
	while(1) {
		
		buf[0] = 0xaa;	// command: read temperature
		if (iow_i2c_write(address, buf, 1, report_size, fd) !=1)
			printf("iic write error\n");
		
		if (iow_i2c_read(address, buf, 2, report_size, fd) !=2)	//read temp registers
			printf("iic read error\n");
		else
			printf("read command byte 0x%0x and 0x%0x\n", buf[0], buf[1]);
		
		short th = buf[0] << 8;
		short tl = buf[1] & 0x00FF;
		printf("Temperature is: %.1f °C\n",(th | tl) / 250.0);
		sleep(1);
	}
	close(fd);
}
