// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  main.c
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      30.08.2008
// *****************************************************************

#include <stdio.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <linux/i2c-dev.h>
#include <linux/i2c.h>

int main(){

	int fd,n;
	char buf[10];

	// use this address for NSLU2 RTC clock
	int addr = 0x6F;

	// use this address for Alekto RTC clock
	//int addr = 0x68;

	if ((fd = open("/dev/i2c-0", O_RDWR)) < 0) {
		printf("open error! %d\n",fd);
		return 1;
	}

	if (ioctl(fd,I2C_SLAVE_FORCE,addr) < 0) {
		printf("address error!\n");
		return 1;
	}

	buf[0] = 0x00;

	printf("write: ");
	n=write(fd,buf,1);
	
	if (n != 1)
		printf("error! %d\n",n);
	else
		printf("0x%x, 0x%x\n",buf[0],buf[1]);

	printf("read: ");
	n=read(fd,buf,1);
	
	if (n != 1)
		printf("read error! %d\n",n);
	else
		printf("0x%x\n",buf[0]);

	close(fd);
	return 0;
}


