// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  main.cpp
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Stephan Riedel, stephan-riedel@gmx.de
// Date:      23.07.2008
// *****************************************************************

#include "iic/Bus.h"
#include "iic/Base.h"
#include "iic/IOExpander.h"

int main() {

	//IICBus bus("/dev/i2c-0",0); // Interface type native iic
	IICBus bus("/dev/iowarrior",1,"00001FEC"); // Interface type iowarrior iic
	IICIOExpander expander(bus, 0x20, "IOExpander");

	bus.autodetect();
	bus.printModules();

	expander.setPortOn(0x00);
	expander.setPortOn(0x03);

	printf("Port status is 0x%02x\n", expander.getPort());

	for(int i=0; i<8; i++){
			printf("Pin %i: %s\n",i, expander.getPin(i)?"HIGH":"LOW");
			usleep(10000);
	}

	return 0;
}

