// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  main.cpp
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      27.04.2008
// *****************************************************************

#include <iostream>

#include "iic/Bus.h"
#include "iic/Base.h"
#include "iic/Display.h"
#include "iic/Keyboard.h"


int main() {
		 
	IICBus bus("/dev/i2c-0",0);
	//IICBus bus("/dev/iowarrior",1,"00001FEC");

	IICDisplay display(bus,0x27, "Display Nr. 1", SIZE_4x20);
	//IICDisplay display(bus,0x27, "Display Nr. 1", SIZE_2x16);
	
	IICKeyboard key(bus,0x20, "Tastatur");
	
	bus.printModules();
	bus.autodetect();
	
	bus.init();	

	display.setBacklight(true);
	display.setDisplay(true);
	display.setCursorMode(true,false);

	// 2x16 display
/*	display.setCursorPos(0,2);
	sprintf(display.getBuf(),"Hello World\n");
	display.printBuf();
	display.setCursorPos(1,0);
	
*/

	// 4x20 display
	display.setCursorPos(0,0);
	sprintf(display.getBuf(),"********************\n");
	display.printBuf();

	display.setCursorPos(1,0);
	sprintf(display.getBuf(),"*   Hello World    *\n");
	display.printBuf();
		
	display.setCursorPos(2,0);
	sprintf(display.getBuf(),"********************\n");
	display.printBuf();

	display.setCursorPos(3,0);


	char ch;
	while(ch != 'e') {

		ch = key.getKey();
		printf("%c\n", ch);
		display.putChar(ch);
		
		if (ch == 'c') display.clear();
		else if (ch == 'A') display.setBacklight(true);
		else if (ch == 'B') display.setBacklight(false);
		else if (ch == 'C') {
				display.clear();
				display.setCursorPos(1,0);
				sprintf(display.getBuf(),"*** FREEZE for 5s ***\n");
				display.printBuf();
				display.setCursorPos(2,0);
				display.freeze(5000);
			}

	}	
	
	display.setDisplay(false);
	display.setBacklight(false);
		
	return 0;
}

