// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  main.cpp
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      27.04.2008
// *****************************************************************

#include <iostream>

#include "iic/Bus.h"
#include "iic/Base.h"
#include "iic/Stepper.h"

int main() {
		
	//IICBus bus("/dev/i2c-0",0);

	IICBus bus("/dev/iowarrior",1,"00001FEC");
	
	IICStepper stepper(bus,0x60, "Stepper Modul");
	
	bus.printModules();
	bus.autodetect();

	bus.init();

	motor_params params;
	
		params.i_run			= 0x0B; // 400mA peak current
		params.i_hold			= 0x03;	// 100mA hold current
		params.v_max			= 0x04;
		params.v_min			= 0x01;	// 1/32 v_max		
		params.shaft			= 0;
		params.step_mode		= 0x03; // 1/16 stepping mode
		params.acc				= 0x02;
		params.acc_shape		= 0x00; // use acc param

	// complete init procedure with drive to reference switch
	if (stepper.referenceInit(params, 0x00, 0x00, -5000, 20) == -1) return -1;
	stepper.getFullStatus2();
	printf("Reference init done, position is now %d\n", stepper.getActualPos());

	sleep(1);
	// now start movement
	stepper.setPosition(5000);
	if (stepper.waitForStop(2000) == -1) return -1;

	stepper.getFullStatus2();
	printf("Position %d reached\n", stepper.getActualPos());

	stepper.getFullStatus1();
	stepper.printParam();
	stepper.printStatus();
	
	cout << "Error " << stepper.getErrCount() << endl;

		
	return 0;
}

