// *****************************************************************
// This file is part of the book "Embedded Linux - Das Praxisbuch"
//
// Copyright (C) 2008-2012 Joachim Schroeder
// Chair Prof. Dillmann (IAIM),
// Institute for Computer Science and Engineering,
// University of Karlsruhe. All rights reserved.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.
// *****************************************************************

// *****************************************************************
// Filename:  otptool.c
// Copyright: Joachim Schroeder, Chair Prof. Dillmann (IAIM),
//            Institute for Computer Science and Engineering (CSE),
//            University of Karlsruhe. All rights reserved.
// Author:    Joachim Schroeder
// Date:      27.04.2008
// *****************************************************************

#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>
#include <linux/i2c-dev.h>
#include <linux/i2c.h>

#define ADDRESS			0x60
#define OSC				0x08
#define IREF			0x04
#define TSD				0x00
#define BG				0x00
#define AD				0x00
#define IRUN			0x0B
#define IHOLD			0x03
#define VMAX			0x04
#define VMIN			0x01
#define SECPOS			500		
#define SHAFT			0x01
#define ACC				0x02
#define STEPMODE		0x03

// #define ACTIVE

int fd;

void getOTPContent() {

	char buf[9];
	int i;
	
	buf[0] = 0x82;	
	write(fd,buf,1);
	read(fd,buf,9);

	printf("Current OTP content is: \n");
	for (i = 1; i < 9; i++)
		printf("OTP byte no %d:  0x%x\n",i-1,buf[i]);
}


int main(){

	char buf[10];
	char otp[8];
	int i;

	if ((fd = open("/dev/i2c-0", O_RDWR)) < 0) {
		printf("open error!\n");
		return 1;
	}

	if (ioctl(fd,I2C_SLAVE_FORCE,ADDRESS) < 0) {
		printf("address error!\n");
		return 1;
	}
	printf("Found device with address 0x%x\n",ADDRESS);
	
	otp[0] = ((char)OSC << 4) | (char)IREF;
	otp[1] = ((char)TSD << 4) | (char)BG;
	otp[2] = (char)AD;
	otp[3] = ((char)IRUN << 4) | (char)IHOLD;
	otp[4] = ((char)VMAX << 4) | (char)VMIN;
	otp[5] = (((int)SECPOS >> 3) & 0xE0) | ((char)SHAFT << 4) | (char)ACC;
	otp[6] = (char)SECPOS;
	otp[7] = ((char)STEPMODE << 2);

	printf("New Settings will be: \n");
	
	for (i = 0; i < 8; i++)
		printf("OTP byte no %d:  0x%x\n",i,otp[i]);
	
	printf("Start programming now? Type Y and (ENTER): \n");
	char ch = getchar();
	if ( ch != 'y' && ch != 'Y') return 1;

#ifdef ACTIVE

	// send data out via several setOtpParam commands
	for (i = 0; i < 8; i++){
		buf[0] = 0x90;
		buf[1] = 0xFF;
		buf[2] = 0xFF;
		buf[3] = i | 0xF8;
		buf[4] = otp[i];
		write(fd,buf,5);
	}
	
#endif
	printf("Programming finished\n");
	getOTPContent();

	close(fd);
}



